/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectInContextIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    @Test
    public void testDoubleRegistration() {
        Artist object = new Artist();
        Assert.assertNull((Object)object.getObjectId());
        this.context.registerNewObject(object);
        ObjectId tempID = object.getObjectId();
        Assert.assertNotNull((Object)tempID);
        Assert.assertTrue((boolean)tempID.isTemporary());
        Assert.assertSame((Object)this.context, (Object)object.getObjectContext());
        this.context.registerNewObject(object);
        Assert.assertSame((Object)tempID, (Object)object.getObjectId());
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(tempID));
        ObjectContext anotherContext = this.runtime.newContext();
        try {
            anotherContext.registerNewObject(object);
            Assert.fail((String)"registerNewObject should've failed - object is already in another context");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    @Test
    public void testCommitChangesInBatch() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("abc1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("abc2");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("abc3");
        this.context.commitChanges();
        List artists = this.context.performQuery(new SelectQuery<Artist>(Artist.class));
        Assert.assertEquals((long)3L, (long)artists.size());
    }

    @Test
    public void testSetObjectId() {
        Artist o1 = new Artist();
        Assert.assertNull((Object)o1.getObjectId());
        this.context.registerNewObject(o1);
        Assert.assertNotNull((Object)o1.getObjectId());
    }

    @Test
    public void testStateTransToNew() {
        Artist o1 = new Artist();
        Assert.assertEquals((long)1L, (long)o1.getPersistenceState());
        this.context.registerNewObject(o1);
        Assert.assertEquals((long)2L, (long)o1.getPersistenceState());
    }

    @Test
    public void testStateNewToCommitted() {
        Artist o1 = new Artist();
        o1.setArtistName("a");
        this.context.registerNewObject(o1);
        Assert.assertEquals((long)2L, (long)o1.getPersistenceState());
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
    }

    @Test
    public void testStateCommittedToModified() {
        Artist o1 = new Artist();
        o1.setArtistName("a");
        this.context.registerNewObject(o1);
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
        o1.setArtistName(o1.getArtistName() + "_1");
        Assert.assertEquals((long)4L, (long)o1.getPersistenceState());
    }

    @Test
    public void testStateModifiedToCommitted() {
        Artist o1 = this.context.newObject(Artist.class);
        o1.setArtistName("qY");
        this.context.commitChanges();
        o1.setArtistName(o1.getArtistName() + "_1");
        Assert.assertEquals((long)4L, (long)o1.getPersistenceState());
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
    }

    @Test
    public void testStateCommittedToDeleted() {
        Artist o1 = new Artist();
        o1.setArtistName("a");
        this.context.registerNewObject(o1);
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)o1.getPersistenceState());
        this.context.deleteObjects(o1);
        Assert.assertEquals((long)6L, (long)o1.getPersistenceState());
    }

    @Test
    public void testStateDeletedToTransient() {
        Artist o1 = this.context.newObject(Artist.class);
        o1.setArtistName("qY");
        this.context.commitChanges();
        this.context.deleteObjects(o1);
        Assert.assertEquals((long)6L, (long)o1.getPersistenceState());
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)o1.getPersistenceState());
        Assert.assertFalse((boolean)this.context.getGraphManager().registeredNodes().contains(o1));
        Assert.assertNull((Object)o1.getObjectContext());
    }

    @Test
    public void testSetContext() {
        Artist o1 = new Artist();
        Assert.assertNull((Object)o1.getObjectContext());
        this.context.registerNewObject(o1);
        Assert.assertSame((Object)this.context, (Object)o1.getObjectContext());
    }

    @Test
    public void testFetchByAttribute() throws Exception {
        this.tArtist.insert(new Object[]{7, "m6"});
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", "m6"));
        List artists = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist o1 = (Artist)artists.get(0);
        Assert.assertNotNull((Object)o1);
        Assert.assertEquals((Object)"m6", (Object)o1.getArtistName());
    }

    @Test
    public void testUniquing() throws Exception {
        this.tArtist.insert(new Object[]{7, "m6"});
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", "m6"));
        Artist a1 = (Artist)Cayenne.objectForQuery(this.context, q);
        Artist a2 = (Artist)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)a1);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((long)1L, (long)this.context.getGraphManager().registeredNodes().size());
        Assert.assertSame((Object)a1, (Object)a2);
    }

    @Test
    public void testSnapshotVersion1() {
        Artist artist = this.context.newObject(Artist.class);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)artist.getSnapshotVersion());
        artist.setArtistName("abc");
        this.context.commitChanges();
        DataRow cachedSnapshot = this.context.getObjectStore().getCachedSnapshot(artist.getObjectId());
        Assert.assertNotNull((Object)cachedSnapshot);
        Assert.assertEquals((long)cachedSnapshot.getVersion(), (long)artist.getSnapshotVersion());
    }

    @Test
    public void testSnapshotVersion2() throws Exception {
        this.tArtist.insert(new Object[]{7, "m6"});
        List artists = this.context.performQuery(new SelectQuery<Artist>(Artist.class));
        Artist artist = (Artist)artists.get(0);
        Assert.assertFalse((Long.MIN_VALUE == artist.getSnapshotVersion() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.context.getObjectStore().getCachedSnapshot(artist.getObjectId()).getVersion(), (long)artist.getSnapshotVersion());
    }

    @Test
    public void testSnapshotVersion3() {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("qY");
        this.context.commitChanges();
        long oldVersion = artist.getSnapshotVersion();
        artist.setArtistName(artist.getArtistName() + "---");
        this.context.commitChanges();
        Assert.assertFalse((oldVersion == artist.getSnapshotVersion() ? 1 : 0) != 0);
        Assert.assertEquals((long)this.context.getObjectStore().getCachedSnapshot(artist.getObjectId()).getVersion(), (long)artist.getSnapshotVersion());
    }

    @Test
    public void testObjectsCommittedManualOID() {
        Artist object = this.context.newObject(Artist.class);
        object.setArtistName("ABC1");
        Assert.assertEquals((long)2L, (long)object.getPersistenceState());
        object.setObjectId(new ObjectId("Artist", "ARTIST_ID", new Integer(3)));
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)object.getPersistenceState());
        this.context.invalidateObjects(object);
        Artist object2 = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 3);
        Assert.assertNotNull((Object)object2);
        Assert.assertEquals((Object)"ABC1", (Object)object2.getArtistName());
    }
}

