/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneDOTestBase;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOOne2OneDepIT
extends CayenneDOTestBase {
    @Inject
    private ObjectContext context1;

    @Test
    public void testRollbackDependent() {
        Artist a1 = this.newArtist();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        this.context.commitChanges();
        PaintingInfo info = this.context.newObject(PaintingInfo.class);
        info.setTextReview("XXX");
        p1.setToPaintingInfo(info);
        Assert.assertSame((Object)info, (Object)p1.getToPaintingInfo());
        this.context.rollbackChanges();
        Assert.assertNull((Object)p1.getToPaintingInfo());
    }

    @Test
    public void test2Null() throws Exception {
        Artist a1 = this.newArtist();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        this.context.commitChanges();
        this.context = this.context1;
        Painting p2 = this.fetchPainting();
        Assert.assertNull((Object)p2.getToPaintingInfo());
    }

    @Test
    public void testReplaceNull() throws Exception {
        Artist a1 = this.newArtist();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        this.context.commitChanges();
        this.context = this.context1;
        Painting p2 = this.fetchPainting();
        p2.setToPaintingInfo(null);
        Assert.assertNull((Object)p2.getToPaintingInfo());
    }

    @Test
    public void testNewAdd() throws Exception {
        Artist a1 = this.newArtist();
        PaintingInfo pi1 = this.newPaintingInfo();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        p1.setToPaintingInfo(pi1);
        Assert.assertSame((Object)pi1, (Object)p1.getToPaintingInfo());
        Assert.assertSame((Object)p1, (Object)pi1.getPainting());
        this.context.commitChanges();
        this.context = this.context1;
        Painting p2 = this.fetchPainting();
        PaintingInfo pi2 = p2.getToPaintingInfo();
        Assert.assertNotNull((Object)pi2);
        Assert.assertEquals((Object)"this painting sucks...", (Object)pi2.getTextReview());
    }

    @Test
    public void testTakeObjectSnapshotDependentFault() throws Exception {
        Artist a1 = this.newArtist();
        PaintingInfo pi1 = this.newPaintingInfo();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        p1.setToPaintingInfo(pi1);
        this.context.commitChanges();
        this.context = this.context1;
        Painting painting = this.fetchPainting();
        Assert.assertTrue((boolean)(painting.readPropertyDirectly("toPaintingInfo") instanceof Fault));
        DataRow snapshot = ((DataContext)this.context).currentSnapshot(painting);
        Assert.assertEquals((Object)"painting about nothing", snapshot.get("PAINTING_TITLE"));
        Assert.assertTrue((boolean)(painting.readPropertyDirectly("toPaintingInfo") instanceof Fault));
    }
}

