/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.cayenne.dbsync.reverse.filters.IncludeTableFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.junit.Assert;
import org.junit.Test;

public class TableFilterTest {
    @Test
    public void testIncludeEverything() {
        TableFilter filter = TableFilter.everything();
        Assert.assertNotNull((Object)filter.isIncludeTable("table"));
        Assert.assertNotNull((Object)filter.isIncludeTable("aaaa"));
        Assert.assertNotNull((Object)filter.isIncludeTable(""));
        Assert.assertNotNull((Object)filter.isIncludeTable("alex"));
    }

    @Test
    public void testInclude() {
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter("aaa"));
        includes.add(new IncludeTableFilter("bb"));
        TableFilter filter = new TableFilter(includes, new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR));
        Assert.assertTrue((boolean)filter.isIncludeTable("aaa"));
        Assert.assertFalse((boolean)filter.isIncludeTable("aa"));
        Assert.assertFalse((boolean)filter.isIncludeTable("aaaa"));
        Assert.assertTrue((boolean)filter.isIncludeTable("bb"));
        Assert.assertFalse((boolean)filter.isIncludeTable(""));
        Assert.assertFalse((boolean)filter.isIncludeTable("bbbb"));
    }

    @Test
    public void testExclude() {
        TreeSet<Pattern> excludes = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        excludes.add(Pattern.compile("aaa"));
        excludes.add(Pattern.compile("bb"));
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(null, PatternFilter.INCLUDE_EVERYTHING));
        TableFilter filter = new TableFilter(includes, excludes);
        Assert.assertFalse((boolean)filter.isIncludeTable("aaa"));
        Assert.assertTrue((boolean)filter.isIncludeTable("aa"));
        Assert.assertTrue((boolean)filter.isIncludeTable("aaaa"));
        Assert.assertFalse((boolean)filter.isIncludeTable("bb"));
        Assert.assertTrue((boolean)filter.isIncludeTable(""));
        Assert.assertTrue((boolean)filter.isIncludeTable("bbbb"));
    }

    @Test
    public void testIncludeExclude() {
        TreeSet<Pattern> excludes = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        excludes.add(Pattern.compile("aaa"));
        excludes.add(Pattern.compile("bb"));
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter("aa.*"));
        TableFilter filter = new TableFilter(includes, excludes);
        Assert.assertFalse((boolean)filter.isIncludeTable("aaa"));
        Assert.assertTrue((boolean)filter.isIncludeTable("aa"));
        Assert.assertTrue((boolean)filter.isIncludeTable("aaaa"));
        Assert.assertFalse((boolean)filter.isIncludeTable("bb"));
        Assert.assertFalse((boolean)filter.isIncludeTable(""));
        Assert.assertFalse((boolean)filter.isIncludeTable("bbbb"));
    }

    @Test
    public void testGetTableFilter() {
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter("aaa"));
        includes.add(new IncludeTableFilter("bb"));
        TreeSet<Pattern> excludes = new TreeSet<Pattern>();
        TableFilter filter = new TableFilter(includes, excludes);
        Assert.assertNotNull((Object)filter.getIncludeTableColumnFilter("aaa"));
        Assert.assertNull((Object)filter.getIncludeTableColumnFilter("aa"));
        Assert.assertNull((Object)filter.getIncludeTableColumnFilter("aaaa"));
        Assert.assertNotNull((Object)filter.getIncludeTableColumnFilter("bb"));
        Assert.assertNull((Object)filter.getIncludeTableColumnFilter(""));
        Assert.assertNull((Object)filter.getIncludeTableColumnFilter("bbbb"));
    }
}

