/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.util.Collection;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbload.AttributeLoader;
import org.apache.cayenne.dbsync.reverse.dbload.BaseLoaderIT;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.EntityLoader;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKeyLoader;
import org.apache.cayenne.dbsync.reverse.dbload.PrimaryKeyLoader;
import org.apache.cayenne.dbsync.reverse.dbload.RelationshipLoader;
import org.apache.cayenne.map.DbRelationship;
import org.junit.Assert;
import org.junit.Test;

public class RelationshipsLoaderIT
extends BaseLoaderIT {
    @Test
    public void testRelationshipLoad() throws Exception {
        boolean supportsFK = this.accessStackAdapter.supportsFKConstraints();
        if (!supportsFK) {
            return;
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        DefaultDbLoaderDelegate delegate = new DefaultDbLoaderDelegate();
        EntityLoader entityLoader = new EntityLoader(this.adapter, EMPTY_CONFIG, delegate);
        AttributeLoader attributeLoader = new AttributeLoader(this.adapter, EMPTY_CONFIG, delegate);
        PrimaryKeyLoader primaryKeyLoader = new PrimaryKeyLoader(EMPTY_CONFIG, delegate);
        ExportedKeyLoader exportedKeyLoader = new ExportedKeyLoader(EMPTY_CONFIG, delegate);
        entityLoader.load(metaData, this.store);
        attributeLoader.load(metaData, this.store);
        primaryKeyLoader.load(metaData, this.store);
        exportedKeyLoader.load(metaData, this.store);
        RelationshipLoader relationshipLoader = new RelationshipLoader(EMPTY_CONFIG, delegate, new DefaultObjectNameGenerator());
        relationshipLoader.load(metaData, this.store);
        Collection rels = this.getDbEntity("ARTIST").getRelationships();
        Assert.assertNotNull((Object)rels);
        Assert.assertTrue((!rels.isEmpty() ? 1 : 0) != 0);
        rels = this.getDbEntity("PAINTING").getRelationships();
        Assert.assertNotNull((Object)rels);
        DbRelationship oneToOne = null;
        for (DbRelationship rel : rels) {
            if (!"PAINTING_INFO".equalsIgnoreCase(rel.getTargetEntityName())) continue;
            oneToOne = rel;
            break;
        }
        Assert.assertNotNull((String)"No relationship to PAINTING_INFO", oneToOne);
        Assert.assertFalse((String)"Relationship to PAINTING_INFO must be to-one", (boolean)oneToOne.isToMany());
        Assert.assertTrue((String)"Relationship to PAINTING_INFO must be to-one", (boolean)oneToOne.isToDependentPK());
    }
}

