/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.util.Map;
import java.util.Set;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.BaseLoaderIT;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKey;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKeyLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class ExportedKeyLoaderIT
extends BaseLoaderIT {
    @Inject
    DbAdapter adapter;

    @Test
    public void testExportedKeyLoad() throws Exception {
        boolean supportsFK = this.accessStackAdapter.supportsFKConstraints();
        if (!supportsFK) {
            return;
        }
        this.createEntity(this.nameForDb("ARTIST"));
        this.createEntity(this.nameForDb("GALLERY"));
        this.createEntity(this.nameForDb("PAINTING"));
        String catalog = this.connection.getCatalog();
        String schema = this.connection.getSchema();
        DbEntity artist = this.getDbEntity("ARTIST");
        if (this.adapter.supportsCatalogsOnReverseEngineering()) {
            artist.setCatalog(catalog);
        }
        artist.setSchema(schema);
        DbAttribute artistId = new DbAttribute("ARTIST_ID");
        artist.addAttribute(artistId);
        DbEntity gallery = this.getDbEntity("GALLERY");
        if (this.adapter.supportsCatalogsOnReverseEngineering()) {
            gallery.setCatalog(catalog);
        }
        gallery.setSchema(schema);
        DbAttribute galleryId = new DbAttribute("GALLERY_ID");
        gallery.addAttribute(galleryId);
        DbEntity painting = this.getDbEntity("PAINTING");
        if (this.adapter.supportsCatalogsOnReverseEngineering()) {
            painting.setCatalog(catalog);
        }
        painting.setSchema(schema);
        DbAttribute paintingId = new DbAttribute("PAINTING_ID");
        DbAttribute paintingArtistId = new DbAttribute("ARTIST_ID");
        DbAttribute paintingGalleryId = new DbAttribute("GALLERY_ID");
        painting.addAttribute(paintingId);
        painting.addAttribute(paintingArtistId);
        painting.addAttribute(paintingGalleryId);
        ExportedKeyLoader loader = new ExportedKeyLoader(EMPTY_CONFIG, new DefaultDbLoaderDelegate());
        loader.load(this.connection.getMetaData(), this.store);
        Assert.assertEquals((long)2L, (long)this.store.getExportedKeysEntrySet().size());
        ExportedKey artistIdFk = this.findArtistExportedKey();
        Assert.assertNotNull((Object)artistIdFk);
        Assert.assertEquals((Object)"ARTIST", (Object)artistIdFk.getPk().getTable().toUpperCase());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)artistIdFk.getPk().getColumn().toUpperCase());
        Assert.assertEquals((Object)"PAINTING", (Object)artistIdFk.getFk().getTable().toUpperCase());
        Assert.assertEquals((Object)"ARTIST_ID", (Object)artistIdFk.getFk().getColumn().toUpperCase());
    }

    private ExportedKey findArtistExportedKey() {
        for (Map.Entry<String, Set<ExportedKey>> entry : this.store.getExportedKeysEntrySet()) {
            if (!entry.getKey().toUpperCase().endsWith(".ARTIST_ID")) continue;
            return entry.getValue().iterator().next();
        }
        return null;
    }
}

