/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.Connection;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.model.DetectedDbEntity;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

@UseServerRuntime(value="cayenne-testmap.xml")
public class BaseLoaderIT
extends ServerCase {
    static final DbLoaderConfiguration EMPTY_CONFIG = new DbLoaderConfiguration();
    @Inject
    protected DbAdapter adapter;
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected ServerCaseDataSourceFactory dataSourceFactory;
    @Inject
    protected UnitDbAdapter accessStackAdapter;
    Connection connection;
    DbLoadDataStore store;

    @Before
    public void before() throws Exception {
        this.store = new DbLoadDataStore();
        Assert.assertTrue((String)"Store is not empty", (boolean)this.store.getDbEntities().isEmpty());
        this.connection = this.dataSourceFactory.getSharedDataSource().getConnection();
    }

    @After
    public void after() throws Exception {
        this.connection.close();
    }

    void createDbEntities() {
        String[] names;
        for (String name : names = new String[]{"ARTIST", "BLOB_TEST", "CLOB_TEST", "GENERATED_COLUMN_TEST"}) {
            this.createEntity(this.nameForDb(name));
        }
    }

    void createEntity(String name) {
        this.store.addDbEntity(new DetectedDbEntity(name));
    }

    DbEntity getDbEntity(String name) {
        DbEntity de = this.store.getDbEntity(name);
        if (de == null) {
            de = this.store.getDbEntity(name.toLowerCase());
        }
        return de;
    }

    String nameForDb(String name) {
        if (this.accessStackAdapter.isLowerCaseNames()) {
            return name.toLowerCase();
        }
        return name.toUpperCase();
    }
}

