/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.reverse.dbload.AttributeLoader;
import org.apache.cayenne.dbsync.reverse.dbload.BaseLoaderIT;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.EntityLoader;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class AttributeLoaderIT
extends BaseLoaderIT {
    @Test
    public void testAttributeLoad() throws Exception {
        this.createDbEntities();
        AttributeLoader loader = new AttributeLoader(this.adapter, EMPTY_CONFIG, new DefaultDbLoaderDelegate());
        loader.load(this.connection.getMetaData(), this.store);
        DbEntity artist = this.getDbEntity("ARTIST");
        DbAttribute a = this.getDbAttribute(artist, "ARTIST_ID");
        Assert.assertNotNull((Object)a);
        if (this.accessStackAdapter.onlyGenericNumberType()) {
            Assert.assertEquals((long)4L, (long)a.getType());
        } else {
            Assert.assertEquals((long)-5L, (long)a.getType());
        }
        Assert.assertTrue((boolean)a.isMandatory());
        Assert.assertFalse((boolean)a.isGenerated());
        a = this.getDbAttribute(artist, "ARTIST_NAME");
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((long)1L, (long)a.getType());
        Assert.assertEquals((long)254L, (long)a.getMaxLength());
        Assert.assertTrue((boolean)a.isMandatory());
        a = this.getDbAttribute(artist, "DATE_OF_BIRTH");
        Assert.assertNotNull((Object)a);
        if (this.accessStackAdapter.onlyGenericDateType()) {
            Assert.assertTrue((91 == a.getType() || 93 == a.getType() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)91L, (long)a.getType());
        }
        Assert.assertFalse((boolean)a.isMandatory());
        if (this.accessStackAdapter.supportsLobs()) {
            this.assertLobDbEntities();
        }
        if (this.adapter.supportsGeneratedKeys()) {
            this.assertGenerated();
        }
    }

    @Test
    public void testAttributeLoadTypes() throws Exception {
        DatabaseMetaData metaData = this.connection.getMetaData();
        DefaultDbLoaderDelegate delegate = new DefaultDbLoaderDelegate();
        EntityLoader entityLoader = new EntityLoader(this.adapter, EMPTY_CONFIG, delegate);
        AttributeLoader attributeLoader = new AttributeLoader(this.adapter, EMPTY_CONFIG, delegate);
        entityLoader.load(metaData, this.store);
        attributeLoader.load(metaData, this.store);
        DbEntity dbe = this.getDbEntity("PAINTING");
        DbEntity floatTest = this.getDbEntity("FLOAT_TEST");
        DbEntity smallintTest = this.getDbEntity("SMALLINT_TEST");
        DbAttribute integerAttr = this.getDbAttribute(dbe, "PAINTING_ID");
        DbAttribute decimalAttr = this.getDbAttribute(dbe, "ESTIMATED_PRICE");
        DbAttribute varcharAttr = this.getDbAttribute(dbe, "PAINTING_TITLE");
        DbAttribute floatAttr = this.getDbAttribute(floatTest, "FLOAT_COL");
        DbAttribute smallintAttr = this.getDbAttribute(smallintTest, "SMALLINT_COL");
        Assert.assertTrue((String)AttributeLoaderIT.msgForTypeMismatch(3, decimalAttr), (3 == decimalAttr.getType() || 2 == decimalAttr.getType() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)decimalAttr.getScale());
        Assert.assertEquals((String)AttributeLoaderIT.msgForTypeMismatch(12, varcharAttr), (long)12L, (long)varcharAttr.getType());
        Assert.assertEquals((long)255L, (long)varcharAttr.getMaxLength());
        Assert.assertEquals((String)AttributeLoaderIT.msgForTypeMismatch(4, integerAttr), (long)4L, (long)integerAttr.getType());
        Assert.assertTrue((String)AttributeLoaderIT.msgForTypeMismatch(6, floatAttr), (6 == floatAttr.getType() || 8 == floatAttr.getType() || 7 == floatAttr.getType() ? 1 : 0) != 0);
        Assert.assertTrue((String)AttributeLoaderIT.msgForTypeMismatch(5, smallintAttr), (5 == smallintAttr.getType() || 4 == smallintAttr.getType() ? 1 : 0) != 0);
    }

    private void assertGenerated() {
        DbEntity bag = this.getDbEntity("GENERATED_COLUMN_TEST");
        DbAttribute id = this.getDbAttribute(bag, "GENERATED_COLUMN");
        Assert.assertTrue((boolean)id.isGenerated());
    }

    private void assertLobDbEntities() {
        DbEntity blobEnt = this.getDbEntity("BLOB_TEST");
        Assert.assertNotNull((Object)blobEnt);
        DbAttribute blobAttr = this.getDbAttribute(blobEnt, "BLOB_COL");
        Assert.assertNotNull((Object)blobAttr);
        Assert.assertTrue((String)AttributeLoaderIT.msgForTypeMismatch(2004, blobAttr), (2004 == blobAttr.getType() || -3 == blobAttr.getType() || -4 == blobAttr.getType() ? 1 : 0) != 0);
        DbEntity clobEnt = this.getDbEntity("CLOB_TEST");
        Assert.assertNotNull((Object)clobEnt);
        DbAttribute clobAttr = this.getDbAttribute(clobEnt, "CLOB_COL");
        Assert.assertNotNull((Object)clobAttr);
        Assert.assertTrue((String)AttributeLoaderIT.msgForTypeMismatch(2005, clobAttr), (2005 == clobAttr.getType() || 12 == clobAttr.getType() || -1 == clobAttr.getType() ? 1 : 0) != 0);
    }

    private DbAttribute getDbAttribute(DbEntity ent, String name) {
        DbAttribute da = ent.getAttribute(name);
        if (da == null) {
            da = ent.getAttribute(name.toLowerCase());
        }
        return da;
    }

    private static String msgForTypeMismatch(int origType, DbAttribute newAttr) {
        String nt = TypesMapping.getSqlNameByType((int)newAttr.getType());
        String ot = TypesMapping.getSqlNameByType((int)origType);
        return AttributeLoaderIT.attrMismatch(newAttr.getName(), "expected type: <" + ot + ">, but was <" + nt + ">");
    }

    private static String attrMismatch(String attrName, String msg) {
        return "[Error loading attribute '" + attrName + "': " + msg + "]";
    }
}

