/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.Iterator;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.junit.Assert;

public class ReverseEngineeringUtils {
    public static void assertCatalog(ReverseEngineering engineering) {
        Iterator<Catalog> catalogs = engineering.getCatalogs().iterator();
        Assert.assertEquals((Object)"catalog-name-01", (Object)catalogs.next().getName());
        Assert.assertEquals((Object)"catalog-name-02", (Object)catalogs.next().getName());
        ReverseEngineeringUtils.assertCatalog(catalogs.next());
    }

    public static void assertCatalog(Catalog catalog) {
        Assert.assertEquals((Object)"catalog-name-03", (Object)catalog.getName());
        Iterator<IncludeTable> includeTables = catalog.getIncludeTables().iterator();
        Assert.assertEquals((Object)"includeTable-01", (Object)includeTables.next().getPattern());
        Assert.assertEquals((Object)"includeTable-02", (Object)includeTables.next().getPattern());
        IncludeTable includeTable = includeTables.next();
        Assert.assertEquals((Object)"includeTable-03", (Object)includeTable.getPattern());
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeTable.getIncludeColumns().iterator().next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-01", (Object)includeTable.getExcludeColumns().iterator().next().getPattern());
        Iterator<ExcludeTable> excludeTables = catalog.getExcludeTables().iterator();
        Assert.assertEquals((Object)"excludeTable-01", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-02", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-03", (Object)excludeTables.next().getPattern());
        Iterator<ExcludeColumn> excludeColumns = catalog.getExcludeColumns().iterator();
        Assert.assertEquals((Object)"excludeColumn-01", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-02", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-03", (Object)excludeColumns.next().getPattern());
        Iterator<IncludeColumn> includeColumns = catalog.getIncludeColumns().iterator();
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-02", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-03", (Object)includeColumns.next().getPattern());
        Iterator<ExcludeProcedure> excludeProcedures = catalog.getExcludeProcedures().iterator();
        Assert.assertEquals((Object)"excludeProcedure-01", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-02", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-03", (Object)excludeProcedures.next().getPattern());
        Iterator<IncludeProcedure> includeProcedures = catalog.getIncludeProcedures().iterator();
        Assert.assertEquals((Object)"includeProcedure-01", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-02", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-03", (Object)includeProcedures.next().getPattern());
    }

    public static void assertSchema(ReverseEngineering engineering) {
        Iterator<Schema> schemas = engineering.getSchemas().iterator();
        Assert.assertEquals((Object)"schema-name-01", (Object)schemas.next().getName());
        Assert.assertEquals((Object)"schema-name-02", (Object)schemas.next().getName());
        Schema schema = schemas.next();
        Assert.assertEquals((Object)"schema-name-03", (Object)schema.getName());
        ReverseEngineeringUtils.assertSchemaContent(schema);
    }

    public static void assertSchemaContent(Schema schema) {
        Iterator<IncludeTable> includeTables = schema.getIncludeTables().iterator();
        Assert.assertEquals((Object)"includeTable-01", (Object)includeTables.next().getPattern());
        Assert.assertEquals((Object)"includeTable-02", (Object)includeTables.next().getPattern());
        IncludeTable includeTable = includeTables.next();
        Assert.assertEquals((Object)"includeTable-03", (Object)includeTable.getPattern());
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeTable.getIncludeColumns().iterator().next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-01", (Object)includeTable.getExcludeColumns().iterator().next().getPattern());
        Iterator<ExcludeTable> excludeTables = schema.getExcludeTables().iterator();
        Assert.assertEquals((Object)"excludeTable-01", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-02", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-03", (Object)excludeTables.next().getPattern());
        Iterator<ExcludeColumn> excludeColumns = schema.getExcludeColumns().iterator();
        Assert.assertEquals((Object)"excludeColumn-01", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-02", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-03", (Object)excludeColumns.next().getPattern());
        Iterator<IncludeColumn> includeColumns = schema.getIncludeColumns().iterator();
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-02", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-03", (Object)includeColumns.next().getPattern());
        Iterator<ExcludeProcedure> excludeProcedures = schema.getExcludeProcedures().iterator();
        Assert.assertEquals((Object)"excludeProcedure-01", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-02", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-03", (Object)excludeProcedures.next().getPattern());
        Iterator<IncludeProcedure> includeProcedures = schema.getIncludeProcedures().iterator();
        Assert.assertEquals((Object)"includeProcedure-01", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-02", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-03", (Object)includeProcedures.next().getPattern());
    }

    public static void assertCatalogAndSchema(ReverseEngineering engineering) {
        Catalog catalog = engineering.getCatalogs().iterator().next();
        Assert.assertEquals((Object)"catalog-name", (Object)catalog.getName());
        Schema schema = catalog.getSchemas().iterator().next();
        Assert.assertEquals((Object)"schema-name", (Object)schema.getName());
        ReverseEngineeringUtils.assertSchemaContent(schema);
    }

    public static void assertFlat(ReverseEngineering engineering) {
        Iterator<IncludeTable> includeTables = engineering.getIncludeTables().iterator();
        Assert.assertEquals((Object)"includeTable-01", (Object)includeTables.next().getPattern());
        Assert.assertEquals((Object)"includeTable-02", (Object)includeTables.next().getPattern());
        IncludeTable includeTable = includeTables.next();
        Assert.assertEquals((Object)"includeTable-03", (Object)includeTable.getPattern());
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeTable.getIncludeColumns().iterator().next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-01", (Object)includeTable.getExcludeColumns().iterator().next().getPattern());
        Iterator<ExcludeTable> excludeTables = engineering.getExcludeTables().iterator();
        Assert.assertEquals((Object)"excludeTable-01", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-02", (Object)excludeTables.next().getPattern());
        Assert.assertEquals((Object)"excludeTable-03", (Object)excludeTables.next().getPattern());
        Iterator<ExcludeColumn> excludeColumns = engineering.getExcludeColumns().iterator();
        Assert.assertEquals((Object)"excludeColumn-01", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-02", (Object)excludeColumns.next().getPattern());
        Assert.assertEquals((Object)"excludeColumn-03", (Object)excludeColumns.next().getPattern());
        Iterator<IncludeColumn> includeColumns = engineering.getIncludeColumns().iterator();
        Assert.assertEquals((Object)"includeColumn-01", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-02", (Object)includeColumns.next().getPattern());
        Assert.assertEquals((Object)"includeColumn-03", (Object)includeColumns.next().getPattern());
        Iterator<ExcludeProcedure> excludeProcedures = engineering.getExcludeProcedures().iterator();
        Assert.assertEquals((Object)"excludeProcedure-01", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-02", (Object)excludeProcedures.next().getPattern());
        Assert.assertEquals((Object)"excludeProcedure-03", (Object)excludeProcedures.next().getPattern());
        Iterator<IncludeProcedure> includeProcedures = engineering.getIncludeProcedures().iterator();
        Assert.assertEquals((Object)"includeProcedure-01", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-02", (Object)includeProcedures.next().getPattern());
        Assert.assertEquals((Object)"includeProcedure-03", (Object)includeProcedures.next().getPattern());
    }

    public static void assertSkipRelationshipsLoading(ReverseEngineering engineering) {
        Assert.assertTrue((boolean)engineering.getSkipRelationshipsLoading());
    }

    public static void assertSkipPrimaryKeyLoading(ReverseEngineering engineering) {
        Assert.assertTrue((boolean)engineering.getSkipPrimaryKeyLoading());
    }

    public static void assertTableTypes(ReverseEngineering engineering) {
        Assert.assertArrayEquals((Object[])new String[]{"type1", "type2", "type3"}, (Object[])engineering.getTableTypes());
    }
}

