/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import org.apache.cayenne.dbsync.naming.PatternStemmer;
import org.junit.Assert;
import org.junit.Test;

public class PatternStemmerTest {
    @Test
    public void testStemNoMatch() {
        Assert.assertEquals((Object)"xyzabc", (Object)new PatternStemmer("^pre", false).stem("xyzabc"));
    }

    @Test
    public void testStemCaseSensitive() {
        Assert.assertEquals((Object)"PREUPPERCASE", (Object)new PatternStemmer("^pre", true).stem("PREUPPERCASE"));
        Assert.assertEquals((Object)"UPPERCASE", (Object)new PatternStemmer("^pre", true).stem("preUPPERCASE"));
    }

    @Test
    public void testStemCaseInsensitive() {
        Assert.assertEquals((Object)"lowercase", (Object)new PatternStemmer("^pre", false).stem("prelowercase"));
        Assert.assertEquals((Object)"UPPERCASE", (Object)new PatternStemmer("^pre", false).stem("PREUPPERCASE"));
    }

    @Test
    public void testStemHead() {
        Assert.assertEquals((Object)"name", (Object)new PatternStemmer("^strip_", false).stem("strip_name"));
        Assert.assertEquals((Object)"strip_name", (Object)new PatternStemmer("^strip_", false).stem("strip_strip_name"));
    }

    @Test
    public void testStemTail() {
        Assert.assertEquals((Object)"name", (Object)new PatternStemmer("_strip$", false).stem("name_strip"));
        Assert.assertEquals((Object)"name_strip", (Object)new PatternStemmer("_strip$", false).stem("name_strip_strip"));
    }

    @Test
    public void testStemMiddle() {
        Assert.assertEquals((Object)"start_end", (Object)new PatternStemmer("_strip", false).stem("start_strip_end"));
        Assert.assertEquals((Object)"start_end", (Object)new PatternStemmer("_strip", false).stem("start_strip_strip_end"));
    }
}

