/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.junit.Assert;
import org.junit.Test;

public class DefaultObjectNameGeneratorTest {
    private DefaultObjectNameGenerator generator = new DefaultObjectNameGenerator(NoStemStemmer.getInstance());

    private DbRelationship makeRelationship(String srcEntity, String srcKey, String targetEntity, String targetKey, boolean toMany) {
        DbRelationship relationship = new DbRelationship();
        relationship.addJoin(new DbJoin(relationship, srcKey, targetKey));
        relationship.setToMany(toMany);
        relationship.setSourceEntity((Entity)new DbEntity(srcEntity));
        relationship.setTargetEntityName(targetEntity);
        return relationship;
    }

    @Test
    public void testRelationshipName_LowerCase_Underscores() {
        DbRelationship r1 = this.makeRelationship("painting", "artist_id", "artist", "artist_id", false);
        Assert.assertEquals((Object)"artist", (Object)this.generator.relationshipName(r1));
        DbRelationship r2 = this.makeRelationship("artist", "artist_id", "painting", "artist_id", true);
        Assert.assertEquals((Object)"paintings", (Object)this.generator.relationshipName(r2));
        DbRelationship r3 = this.makeRelationship("person", "mother_id", "person", "person_id", false);
        Assert.assertEquals((Object)"mother", (Object)this.generator.relationshipName(r3));
        DbRelationship r4 = this.makeRelationship("person", "person_id", "person", "mother_id", true);
        Assert.assertEquals((Object)"people", (Object)this.generator.relationshipName(r4));
        DbRelationship r5 = this.makeRelationship("person", "shipping_address_id", "address", "id", false);
        Assert.assertEquals((Object)"shippingAddress", (Object)this.generator.relationshipName(r5));
        DbRelationship r6 = this.makeRelationship("person", "id", "address", "person_id", true);
        Assert.assertEquals((Object)"addresses", (Object)this.generator.relationshipName(r6));
    }

    @Test
    public void testRelationshipName_UpperCase_Underscores() {
        DbRelationship r1 = this.makeRelationship("PAINTING", "ARTIST_ID", "ARTIST", "ARTIST_ID", false);
        Assert.assertEquals((Object)"artist", (Object)this.generator.relationshipName(r1));
        DbRelationship r2 = this.makeRelationship("ARTIST", "ARTIST_ID", "PAINTING", "ARTIST_ID", true);
        Assert.assertEquals((Object)"paintings", (Object)this.generator.relationshipName(r2));
        DbRelationship r3 = this.makeRelationship("PERSON", "MOTHER_ID", "PERSON", "PERSON_ID", false);
        Assert.assertEquals((Object)"mother", (Object)this.generator.relationshipName(r3));
        DbRelationship r4 = this.makeRelationship("PERSON", "PERSON_ID", "PERSON", "MOTHER_ID", true);
        Assert.assertEquals((Object)"people", (Object)this.generator.relationshipName(r4));
        DbRelationship r5 = this.makeRelationship("PERSON", "SHIPPING_ADDRESS_ID", "ADDRESS", "ID", false);
        Assert.assertEquals((Object)"shippingAddress", (Object)this.generator.relationshipName(r5));
        DbRelationship r6 = this.makeRelationship("PERSON", "ID", "ADDRESS", "PERSON_ID", true);
        Assert.assertEquals((Object)"addresses", (Object)this.generator.relationshipName(r6));
    }

    @Test
    public void testObjEntityName() {
        Assert.assertEquals((Object)"Artist", (Object)this.generator.objEntityName(new DbEntity("ARTIST")));
        Assert.assertEquals((Object)"ArtistWork", (Object)this.generator.objEntityName(new DbEntity("ARTIST_WORK")));
    }

    @Test
    public void testObjAttributeName() {
        Assert.assertEquals((Object)"name", (Object)this.generator.objAttributeName(new DbAttribute("NAME")));
        Assert.assertEquals((Object)"artistName", (Object)this.generator.objAttributeName(new DbAttribute("ARTIST_NAME")));
    }
}

