/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import java.util.List;
import org.apache.cayenne.dbsync.merge.MergeCase;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.DropTableToModel;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Test;

public class DropTableToModelIT
extends MergeCase {
    @Test
    public void testDropTable() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        DbAttribute column1 = new DbAttribute("ID", 4, dbEntity);
        column1.setMandatory(true);
        column1.setPrimaryKey(true);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NAME", 12, dbEntity);
        column2.setMaxLength(10);
        column2.setMandatory(false);
        dbEntity.addAttribute(column2);
        this.map.addDbEntity(dbEntity);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        ObjEntity objEntity = new ObjEntity("NewTable");
        objEntity.setDbEntity(dbEntity);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(column2.getName());
        oatr1.setType("java.lang.String");
        objEntity.addAttribute((Attribute)oatr1);
        this.map.addObjEntity(objEntity);
        MergerToken token = this.mergerFactory().createDropTableToDb(dbEntity);
        this.execute(token);
        List<MergerToken> tokens = this.createMergeTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        token = tokens.get(0);
        if (token.getDirection().isToDb()) {
            token = token.createReverse(this.mergerFactory());
        }
        Assert.assertTrue((boolean)(token instanceof DropTableToModel));
        this.execute(token);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        this.map.removeObjEntity(objEntity.getName(), true);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(0, 0);
    }
}

