/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token;

import java.util.Collections;
import org.apache.cayenne.dbsync.merge.builders.ObjectMother;
import org.apache.cayenne.dbsync.merge.factory.HSQLMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.DefaultValueForNullProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Procedure;
import org.junit.Assert;
import org.junit.Test;

public class TokensReverseTest {
    @Test
    public void testReverses() {
        DbAttribute attr = ObjectMother.dbAttr().build();
        DbEntity entity = ObjectMother.dbEntity().attributes(attr).build();
        DbRelationship rel = new DbRelationship("rel");
        rel.setSourceEntity((Entity)entity);
        rel.addJoin(new DbJoin(rel, attr.getName(), "dontKnow"));
        Procedure procedure = new Procedure("Test");
        this.testOneToOneReverse(this.factory().createAddColumnToDb(entity, attr));
        this.testOneToOneReverse(this.factory().createAddColumnToModel(entity, attr));
        this.testOneToOneReverse(this.factory().createDropColumnToDb(entity, attr));
        this.testOneToOneReverse(this.factory().createDropColumnToModel(entity, attr));
        this.testOneToOneReverse(this.factory().createAddRelationshipToDb(entity, rel));
        this.testOneToOneReverse(this.factory().createAddRelationshipToModel(entity, rel));
        this.testOneToOneReverse(this.factory().createDropRelationshipToDb(entity, rel));
        this.testOneToOneReverse(this.factory().createDropRelationshipToModel(entity, rel));
        this.testOneToOneReverse(this.factory().createCreateTableToDb(entity));
        this.testOneToOneReverse(this.factory().createCreateTableToModel(entity));
        this.testOneToOneReverse(this.factory().createDropTableToDb(entity));
        this.testOneToOneReverse(this.factory().createDropTableToModel(entity));
        this.testOneToOneReverse(this.factory().createSetAllowNullToDb(entity, attr));
        this.testOneToOneReverse(this.factory().createSetAllowNullToModel(entity, attr));
        this.testOneToOneReverse(this.factory().createSetNotNullToDb(entity, attr));
        this.testOneToOneReverse(this.factory().createSetNotNullToModel(entity, attr));
        DbAttribute attr2 = ObjectMother.dbAttr().build();
        this.testOneToOneReverse(this.factory().createSetColumnTypeToDb(entity, attr, attr2));
        this.testOneToOneReverse(this.factory().createSetColumnTypeToModel(entity, attr, attr2));
        this.testOneToOneReverse(this.factory().createSetPrimaryKeyToDb(entity, Collections.singleton(attr), Collections.singleton(attr2), "PK"));
        this.testOneToOneReverse(this.factory().createSetPrimaryKeyToModel(entity, Collections.singleton(attr), Collections.singleton(attr2), "PK"));
        this.testOneToOneReverse(this.factory().createSetValueForNullToDb(entity, attr, new DefaultValueForNullProvider()));
        this.testOneToOneReverse(this.factory().createDropProcedureToDb(procedure));
        this.testOneToOneReverse(this.factory().createAddProcedureToDb(procedure));
        this.testOneToOneReverse(this.factory().createDropProcedureToModel(procedure));
        this.testOneToOneReverse(this.factory().createAddProcedureToModel(procedure));
    }

    private void testOneToOneReverse(MergerToken token) {
        MergerToken token2 = token.createReverse(this.factory()).createReverse(this.factory());
        Assert.assertEquals((Object)token.getTokenName(), (Object)token2.getTokenName());
        Assert.assertEquals((Object)token.getTokenValue(), (Object)token2.getTokenValue());
        Assert.assertEquals((Object)((Object)token.getDirection()), (Object)((Object)token2.getDirection()));
    }

    private MergerTokenFactory factory() {
        return new HSQLMergerTokenFactory();
    }
}

