/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.builders;

import java.util.Collections;
import org.apache.cayenne.dbsync.merge.builders.DbEntityBuilder;
import org.apache.cayenne.dbsync.merge.builders.DbRelationshipBuilder;
import org.apache.cayenne.dbsync.merge.builders.DefaultBuilder;
import org.apache.cayenne.dbsync.merge.builders.ObjEntityBuilder;
import org.apache.cayenne.dbsync.merge.builders.ObjectMother;
import org.apache.cayenne.dbsync.merge.builders.ProcedureBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;

public class DataMapBuilder
extends DefaultBuilder<DataMap> {
    public DataMapBuilder() {
        this(new DataMap());
    }

    public DataMapBuilder(DataMap dataMap) {
        super(dataMap);
    }

    public DataMapBuilder with(DbEntity ... entities) {
        for (DbEntity entity : entities) {
            ((DataMap)this.obj).addDbEntity(entity);
        }
        return this;
    }

    public DataMapBuilder with(DbEntityBuilder ... entities) {
        for (DbEntityBuilder entity : entities) {
            ((DataMap)this.obj).addDbEntity(entity.build());
        }
        return this;
    }

    public DataMapBuilder withDbEntities(int count) {
        for (int i = 0; i < count; ++i) {
            ((DataMap)this.obj).addDbEntity(ObjectMother.dbEntity().random());
        }
        return this;
    }

    public DataMapBuilder with(ObjEntity ... entities) {
        for (ObjEntity entity : entities) {
            ((DataMap)this.obj).addObjEntity(entity);
        }
        return this;
    }

    public DataMapBuilder with(ObjEntityBuilder ... entities) {
        for (ObjEntityBuilder entity : entities) {
            ((DataMap)this.obj).addObjEntity(entity.build());
        }
        return this;
    }

    public DataMapBuilder withObjEntities(int count) {
        for (int i = 0; i < count; ++i) {
            ((DataMap)this.obj).addObjEntity(ObjectMother.objEntity().random());
        }
        return this;
    }

    public DataMapBuilder join(String from, String to) {
        return this.join(null, from, to);
    }

    public DataMapBuilder join(String name, String from, String to) {
        String[] fromSplit = from.split("\\.");
        DbEntity fromEntity = ((DataMap)this.obj).getDbEntity(fromSplit[0]);
        if (fromEntity == null) {
            throw new IllegalArgumentException("Entity '" + fromSplit[0] + "' is undefined");
        }
        String[] toSplit = to.split("\\.");
        fromEntity.addRelationship((Relationship)new DbRelationshipBuilder(name).from(fromEntity, fromSplit[1]).to(toSplit[0], toSplit[1]).build());
        return this;
    }

    public DataMapBuilder with(ProcedureBuilder ... procedures) {
        for (ProcedureBuilder builder : procedures) {
            ((DataMap)this.obj).addProcedure(builder.build());
        }
        return this;
    }

    public DataMapBuilder with(Procedure ... procedures) {
        for (Procedure procedure : procedures) {
            ((DataMap)this.obj).addProcedure(procedure);
        }
        return this;
    }

    @Override
    public DataMap build() {
        if (((DataMap)this.obj).getNamespace() == null) {
            ((DataMap)this.obj).setNamespace((MappingNamespace)new EntityResolver(Collections.singleton((DataMap)this.obj)));
        }
        return (DataMap)this.obj;
    }

    @Override
    public DataMap random() {
        if (this.dataFactory.chance(90)) {
            this.withDbEntities(this.dataFactory.getNumberUpTo(10));
        }
        return this.build();
    }
}

