/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.List;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.builders.DbEntityBuilder;
import org.apache.cayenne.dbsync.merge.builders.ObjectMother;
import org.apache.cayenne.dbsync.merge.factory.HSQLMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.SetColumnTypeToDb;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ProcedureParameter;
import org.junit.Assert;
import org.junit.Test;

public class DataMapMergerTest {
    @Test
    public void testEmptyDataMap() throws Exception {
        DataMap existing = ObjectMother.dataMap().build();
        DataMap db = ObjectMother.dataMap().build();
        Assert.assertEquals((long)0L, (long)this.dbMerger().createMergeTokens(existing, db).size());
    }

    @Test
    public void testAddTable() throws Exception {
        DbEntityBuilder dbEntity = ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt());
        DataMap existing = ObjectMother.dataMap().with(dbEntity).build();
        DataMap db = ObjectMother.dataMap().build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)this.factory().createCreateTableToDb(dbEntity.build()).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testRemoveTable() throws Exception {
        DataMap existing = ObjectMother.dataMap().build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)this.factory().createDropTableToDb(db.getDbEntity("table1")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testAddColumn() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddColumnToDb(entity, entity.getAttribute("attr02")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testChangeColumnTypeSimple() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeVarchar(30))).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        DbEntity entityDb = db.getDbEntity("table1");
        Assert.assertTrue((boolean)(tokens.get(0) instanceof SetColumnTypeToDb));
        Assert.assertEquals((Object)this.factory().createSetColumnTypeToDb(entity, entityDb.getAttribute("attr01"), entity.getAttribute("attr01")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testChangeColumnLength() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeVarchar(60))).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeVarchar(30))).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        DbEntity entityDb = db.getDbEntity("table1");
        Assert.assertTrue((boolean)(tokens.get(0) instanceof SetColumnTypeToDb));
        Assert.assertEquals((Object)this.factory().createSetColumnTypeToDb(entity, entityDb.getAttribute("attr01"), entity.getAttribute("attr01")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testChangeColumnType() throws Exception {
        DbEntity fromModel = ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").type("DATE"), ObjectMother.dbAttr("attr03").type("BOOLEAN"), ObjectMother.dbAttr("attr04").type("FLOAT")).build();
        DataMap existing = ObjectMother.dataMap().with(fromModel).build();
        DbEntity fromDb = ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeBigInt(), ObjectMother.dbAttr("attr02").type("NUMERIC"), ObjectMother.dbAttr("attr03").type("BLOB"), ObjectMother.dbAttr("attr04").type("TIMESTAMP")).build();
        DataMap db = ObjectMother.dataMap().with(fromDb).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)4L, (long)tokens.size());
        for (MergerToken token : tokens) {
            Assert.assertTrue((boolean)(token instanceof SetColumnTypeToDb));
        }
        MergerToken attr02Token = this.findChangeTypeToken(tokens, "attr02");
        Assert.assertNotNull((Object)attr02Token);
        Assert.assertEquals((Object)this.factory().createSetColumnTypeToDb(fromModel, fromDb.getAttribute("attr02"), fromModel.getAttribute("attr02")).getTokenValue(), (Object)attr02Token.getTokenValue());
    }

    private MergerToken findChangeTypeToken(List<MergerToken> tokens, String attributeName) {
        for (MergerToken token : tokens) {
            if (!token.getTokenValue().contains("." + attributeName)) continue;
            return token;
        }
        return null;
    }

    @Test
    public void testDropPrimaryKey() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
    }

    @Test
    public void testAddPrimaryKey() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
    }

    @Test
    public void testAddRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).join("rel", "table1.attr01", "table2.attr01").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testAddRelationship1() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr01").join("rel1", "table1.attr01", "table2.attr03").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr02").join("rel1", "table1.attr01", "table2.attr03").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)2L, (long)tokens.size());
        DbEntity entity = existing.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
        entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createAddRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testTableNameUppercaseRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("TABLE1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "TABLE1.attr01", "table2.attr01").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr01").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)0L, (long)tokens.size());
    }

    @Test
    public void testAttributeNameUppercaseRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("ATTR01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.ATTR01", "table2.attr01").build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt().primaryKey(), ObjectMother.dbAttr("attr03").typeInt().primaryKey())).join("rel", "table1.attr01", "table2.attr01").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)0L, (long)tokens.size());
    }

    @Test
    public void testRemoveRelationship() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt()), ObjectMother.dbEntity("table2").attributes(ObjectMother.dbAttr("attr01").typeInt().primaryKey(), ObjectMother.dbAttr("attr02").typeInt())).join("rel", "table1.attr01", "table2.attr01").build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropRelationshipToDb(entity, entity.getRelationship("rel")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testRemoveColumn() throws Exception {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt())).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)1L, (long)tokens.size());
        DbEntity entity = db.getDbEntity("table1");
        Assert.assertEquals((Object)this.factory().createDropColumnToModel(entity, entity.getAttribute("attr02")).getTokenValue(), (Object)tokens.get(0).getTokenValue());
    }

    @Test
    public void testChangeGeneratedStatus() {
        DataMap existing = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeVarchar(10))).build();
        DataMap db = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt().generated())).build();
        List<MergerToken> tokens = this.dbMerger().createMergeTokens(existing, db);
        Assert.assertEquals((long)2L, (long)tokens.size());
    }

    @Test
    public void testNoChanges() throws Exception {
        DataMap dataMap1 = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt(), ObjectMother.dbAttr("attr03").typeInt())).build();
        DataMap dataMap2 = ObjectMother.dataMap().with(ObjectMother.dbEntity("table1").attributes(ObjectMother.dbAttr("attr01").typeInt(), ObjectMother.dbAttr("attr02").typeInt(), ObjectMother.dbAttr("attr03").typeInt())).build();
        Assert.assertEquals((long)0L, (long)this.dbMerger().createMergeTokens(dataMap1, dataMap2).size());
    }

    @Test
    public void testProcedures() {
        DataMap dataMap1 = ObjectMother.dataMap().with(ObjectMother.procedure("proc1").callParameters(new ProcedureParameter("test"))).build();
        DataMap dataMap2 = ObjectMother.dataMap().build();
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.include("proc1");
        FiltersConfig filtersConfig = FiltersConfig.create(null, null, null, patternFilter);
        DataMapMerger merger = DataMapMerger.builder(this.factory()).filters(filtersConfig).build();
        Assert.assertEquals((long)1L, (long)merger.createMergeTokens(dataMap1, dataMap2).size());
    }

    private DataMapMerger dbMerger() {
        return DataMapMerger.build(this.factory());
    }

    private HSQLMergerTokenFactory factory() {
        return new HSQLMergerTokenFactory();
    }
}

