/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import org.apache.cayenne.dbsync.merge.DbAttributeMerger;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MySQLMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.PostgresMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CheckTypeTest {
    DbEntity dbEntity;
    DbAttribute original;
    DbAttribute imported;
    MergerTokenFactory mergerTokenFactory;
    MergerDiffPair<DbAttribute> diffPair;
    DbAttributeMerger dbAttributeMerger;

    @Before
    public void setUp() {
        this.dbEntity = new DbEntity("NEW_TABLE");
        this.original = new DbAttribute("NAME");
        this.original.setEntity((Entity)this.dbEntity);
        this.dbEntity.addAttribute(this.original);
        this.imported = new DbAttribute("NAME");
        this.imported.setEntity((Entity)this.dbEntity);
        this.mergerTokenFactory = new MySQLMergerTokenFactory();
        this.diffPair = new MergerDiffPair<DbAttribute>(this.original, this.imported);
        this.dbAttributeMerger = new DbAttributeMerger(this.mergerTokenFactory, null);
    }

    @Test
    public void testCheckBooleanBitTypeMySQL() {
        this.original.setType(16);
        this.imported.setType(-7);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)0L, (long)mergerTokens.size());
    }

    @Test
    public void testCheckBlobLongvarbinaryTypeMySQL() {
        this.original.setType(2004);
        this.imported.setType(-4);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)0L, (long)mergerTokens.size());
    }

    @Test
    public void testCheckBooleanIntegerTypeMySQL() {
        this.original.setType(16);
        this.imported.setType(4);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME type: INTEGER -> BOOLEAN";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testCheckBooleanBitTypePostgres() {
        this.original.setType(16);
        this.imported.setType(-7);
        this.mergerTokenFactory = new PostgresMergerTokenFactory();
        this.dbAttributeMerger = new DbAttributeMerger(this.mergerTokenFactory, null);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME type: BIT -> BOOLEAN";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testCheckNumericDecimalType() {
        this.original.setType(2);
        this.imported.setType(3);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)0L, (long)mergerTokens.size());
    }

    @Test
    public void testCheckMaxLengthType() {
        this.original.setType(1);
        this.original.setMaxLength(1);
        this.imported.setType(1);
        this.imported.setMaxLength(2);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME maxLength: 2 -> 1";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testCheckScaleType() {
        this.original.setScale(1);
        this.imported.setScale(2);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME scale: 2 -> 1";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testCheckAttributePrecisionType() {
        this.original.setAttributePrecision(1);
        this.imported.setAttributePrecision(2);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME precision: 2 -> 1";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testTimeType() {
        this.original.setType(93);
        this.original.setMaxLength(19);
        this.imported.setType(93);
        this.imported.setMaxLength(0);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)1L, (long)mergerTokens.size());
        MergerToken mergerToken1 = (MergerToken)mergerTokens.toArray()[0];
        String mergerToken = "NEW_TABLE.NAME maxLength: 0 -> 19";
        Assert.assertEquals((Object)mergerToken, (Object)mergerToken1.getTokenValue());
    }

    @Test
    public void testCheckTypeWithoutChanges() {
        this.diffPair = new MergerDiffPair<DbAttribute>(this.original, this.imported);
        this.dbAttributeMerger = new DbAttributeMerger(this.mergerTokenFactory, null);
        Collection<MergerToken> mergerTokens = this.dbAttributeMerger.createTokensForSame(this.diffPair);
        Assert.assertEquals((long)0L, (long)mergerTokens.size());
    }
}

