/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerCatalogAndSchemaLoader;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureColumnLoader
extends PerCatalogAndSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);

    ProcedureColumnLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    protected ResultSet getResultSet(String catalogName, String schemaName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getProcedureColumns(catalogName, schemaName, "%", "%");
    }

    @Override
    protected boolean shouldLoad(CatalogFilter catalog, SchemaFilter schema) {
        PatternFilter filter = this.config.getFiltersConfig().proceduresFilter(catalog.name, schema.name);
        return !filter.isEmpty();
    }

    @Override
    protected void processResultSetRow(CatalogFilter catalog, SchemaFilter schema, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String name;
        String procSchema = rs.getString("PROCEDURE_SCHEM");
        String procCatalog = rs.getString("PROCEDURE_CAT");
        String key = Procedure.generateFullyQualifiedName((String)procCatalog, (String)procSchema, (String)(name = rs.getString("PROCEDURE_NAME")));
        Procedure procedure = map.getProcedure(key);
        if (procedure == null) {
            return;
        }
        ProcedureParameter column = this.loadProcedureParams(rs, key, procedure);
        if (column == null) {
            return;
        }
        procedure.addCallParameter(column);
    }

    private ProcedureParameter loadProcedureParams(ResultSet rs, String key, Procedure procedure) throws SQLException {
        String columnName = rs.getString("COLUMN_NAME");
        short type = rs.getShort("COLUMN_TYPE");
        if (type == 3) {
            LOGGER.debug("skipping ResultSet column: " + key + "." + columnName);
            return null;
        }
        if (columnName == null) {
            if (type == 5) {
                LOGGER.debug("null column name, assuming result column: " + key);
                columnName = "_return_value";
                procedure.setReturningValue(true);
            } else {
                LOGGER.info("invalid null column name, skipping column : " + key);
                return null;
            }
        }
        int columnType = rs.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal((int)columnType)) {
            decimalDigits = rs.getShort("SCALE");
            if (rs.wasNull()) {
                decimalDigits = -1;
            }
        }
        ProcedureParameter column = new ProcedureParameter(columnName);
        column.setDirection(this.getDirection(type));
        column.setType(columnType);
        column.setMaxLength(rs.getInt("LENGTH"));
        column.setPrecision(decimalDigits);
        column.setProcedure(procedure);
        return column;
    }

    private int getDirection(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 2;
            }
        }
        return -1;
    }
}

