/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.util.CompareToBuilder;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;

public class ExportedKey
implements Comparable {
    private final KeyData pk;
    private final KeyData fk;
    private final short keySeq;

    ExportedKey(ResultSet rs) throws SQLException {
        String pkCatalog = rs.getString("PKTABLE_CAT");
        String pkSchema = rs.getString("PKTABLE_SCHEM");
        String pkTable = rs.getString("PKTABLE_NAME");
        String pkColumn = rs.getString("PKCOLUMN_NAME");
        String pkName = rs.getString("PK_NAME");
        this.pk = new KeyData(pkCatalog, pkSchema, pkTable, pkColumn, pkName);
        String fkCatalog = rs.getString("FKTABLE_CAT");
        String fkSchema = rs.getString("FKTABLE_SCHEM");
        String fkTable = rs.getString("FKTABLE_NAME");
        String fkColumn = rs.getString("FKCOLUMN_NAME");
        String fkName = rs.getString("FK_NAME");
        this.fk = new KeyData(fkCatalog, fkSchema, fkTable, fkColumn, fkName);
        this.keySeq = rs.getShort("KEY_SEQ");
    }

    public KeyData getPk() {
        return this.pk;
    }

    public KeyData getFk() {
        return this.fk;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExportedKey rhs = (ExportedKey)obj;
        return new EqualsBuilder().append((Object)this.pk, (Object)rhs.pk).append((Object)this.fk, (Object)rhs.fk).append(this.keySeq, rhs.keySeq).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.pk).append((Object)this.fk).append(this.keySeq).toHashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException();
        }
        if (obj == this) {
            return 0;
        }
        ExportedKey rhs = (ExportedKey)obj;
        return new CompareToBuilder().append((Object)this.pk, (Object)rhs.pk).append((Object)this.fk, (Object)rhs.fk).append(this.keySeq, rhs.keySeq).toComparison();
    }

    public String toString() {
        return this.getStrKey() + " # " + this.keySeq;
    }

    String getStrKey() {
        return this.pk + " <- " + this.fk;
    }

    public static class KeyData
    implements Comparable {
        private final String catalog;
        private final String schema;
        private final String table;
        private final String column;
        private final String name;

        KeyData(String catalog, String schema, String table, String column, String name) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.column = column;
            this.name = name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public String getColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.catalog + "." + this.schema + "." + this.table + "." + this.column;
        }

        public int compareTo(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                throw new IllegalArgumentException();
            }
            if (obj == this) {
                return 0;
            }
            KeyData rhs = (KeyData)obj;
            return new CompareToBuilder().append((Object)this.catalog, (Object)rhs.catalog).append((Object)this.schema, (Object)rhs.schema).append((Object)this.table, (Object)rhs.table).append((Object)this.column, (Object)rhs.column).append((Object)this.name, (Object)rhs.name).toComparison();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            KeyData rhs = (KeyData)obj;
            return new EqualsBuilder().append((Object)this.catalog, (Object)rhs.catalog).append((Object)this.schema, (Object)rhs.schema).append((Object)this.table, (Object)rhs.table).append((Object)this.column, (Object)rhs.column).append((Object)this.name, (Object)rhs.name).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.catalog).append((Object)this.schema).append((Object)this.table).append((Object)this.column).append((Object)this.name).toHashCode();
        }
    }
}

