/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.SQLException;
import org.apache.cayenne.dbsync.reverse.dbload.BaseLoaderIT;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.EntityLoader;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class EntityLoaderIT
extends BaseLoaderIT {
    @Test
    public void testGetTablesWithWrongCatalog() throws Exception {
        DbLoaderConfiguration config = new DbLoaderConfiguration();
        config.setFiltersConfig(FiltersConfig.create("WRONG", null, TableFilter.everything(), PatternFilter.INCLUDE_NOTHING));
        EntityLoader loader = new EntityLoader(this.adapter, config, new DefaultDbLoaderDelegate());
        try {
            loader.load(this.connection.getMetaData(), this.store);
        }
        catch (SQLException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("WRONG"));
        }
        Assert.assertTrue((String)"Store is not empty", (boolean)this.store.getDbEntities().isEmpty());
    }

    @Test
    public void testGetTablesWithWrongSchema() throws Exception {
        DbLoaderConfiguration config = new DbLoaderConfiguration();
        config.setFiltersConfig(FiltersConfig.create(null, "WRONG", TableFilter.everything(), PatternFilter.INCLUDE_NOTHING));
        EntityLoader loader = new EntityLoader(this.adapter, config, new DefaultDbLoaderDelegate());
        loader.load(this.connection.getMetaData(), this.store);
        Assert.assertTrue((String)"Store is not empty", (boolean)this.store.getDbEntities().isEmpty());
    }

    @Test
    public void testLoad() throws Exception {
        EntityLoader loader = new EntityLoader(this.adapter, EMPTY_CONFIG, new DefaultDbLoaderDelegate());
        loader.load(this.connection.getMetaData(), this.store);
        Assert.assertFalse((String)"Store not empty", (boolean)this.store.getDbEntities().isEmpty());
        this.assertDbEntities();
        if (this.accessStackAdapter.supportsLobs()) {
            this.assertLobDbEntities();
        }
    }

    private void assertDbEntities() {
        DbEntity dae = this.getDbEntity("ARTIST");
        Assert.assertNotNull((String)("Null 'ARTIST' entity, other DbEntities: " + this.store.getDbEntityMap()), (Object)dae);
        Assert.assertEquals((Object)"ARTIST", (Object)dae.getName().toUpperCase());
        if (this.adapter.supportsGeneratedKeys()) {
            DbEntity bag = this.getDbEntity("GENERATED_COLUMN_TEST");
            Assert.assertNotNull((String)("Null 'GENERATED_COLUMN_TEST' entity, other DbEntities: " + this.store.getDbEntityMap()), (Object)bag);
        }
    }

    private void assertLobDbEntities() {
        DbEntity blobEnt = this.getDbEntity("BLOB_TEST");
        Assert.assertNotNull((Object)blobEnt);
        DbEntity clobEnt = this.getDbEntity("CLOB_TEST");
        Assert.assertNotNull((Object)clobEnt);
    }
}

