/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.net.URL;
import java.util.ArrayList;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DefaultConfigurationNameMapper;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.DefaultHandlerFactory;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.NoopDataChannelMetaData;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.configuration.xml.XMLDataMapLoader;
import org.apache.cayenne.configuration.xml.XMLReaderProvider;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.reverse.dbimport.ManyToManyCandidateEntity;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.di.spi.DefaultClassLoaderManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.XMLReader;

public class ManyToManyCandidateEntityTest {
    private DataMap map;

    @Before
    public void setUp() throws Exception {
        Module testModule = binder -> {
            binder.bind(ClassLoaderManager.class).to(DefaultClassLoaderManager.class);
            binder.bind(AdhocObjectFactory.class).to(DefaultAdhocObjectFactory.class);
            binder.bind(DataMapLoader.class).to(XMLDataMapLoader.class);
            binder.bind(ConfigurationNameMapper.class).to(DefaultConfigurationNameMapper.class);
            binder.bind(HandlerFactory.class).to(DefaultHandlerFactory.class);
            binder.bind(DataChannelMetaData.class).to(NoopDataChannelMetaData.class);
            binder.bind(XMLReader.class).toProviderInstance((Provider)new XMLReaderProvider(false)).withoutScope();
        };
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{testModule});
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        injector.injectMembers((Object)loader);
        String testConfigName = "relationship-optimisation";
        URL url = this.getClass().getResource("cayenne-" + testConfigName + ".xml");
        ConfigurationTree tree = loader.load((Resource)new URLResource(url));
        this.map = ((DataChannelDescriptor)tree.getRootNode()).getDataMap(testConfigName);
    }

    @Test
    public void testMatchingForManyToManyEntity() throws Exception {
        ObjEntity manyToManyEntity = this.map.getObjEntity("Table1Table2");
        Assert.assertNotNull((Object)ManyToManyCandidateEntity.build(manyToManyEntity));
    }

    @Test
    public void testMatchingForNotManyToManyEntity() throws Exception {
        ObjEntity entity = this.map.getObjEntity("Table1");
        Assert.assertNull((Object)ManyToManyCandidateEntity.build(entity));
    }

    @Test
    public void testOptimisationForManyToManyEntity() {
        ObjEntity manyToManyEntity = this.map.getObjEntity("Table1Table2");
        ManyToManyCandidateEntity.build(manyToManyEntity).optimizeRelationships(new DefaultObjectNameGenerator(NoStemStemmer.getInstance()));
        ObjEntity table1Entity = this.map.getObjEntity("Table1");
        ObjEntity table2Entity = this.map.getObjEntity("Table2");
        Assert.assertEquals((long)1L, (long)table1Entity.getRelationships().size());
        Assert.assertEquals((Object)table2Entity, (Object)((Relationship)new ArrayList(table1Entity.getRelationships()).get(0)).getTargetEntity());
        Assert.assertEquals((long)1L, (long)table2Entity.getRelationships().size());
        Assert.assertEquals((Object)table1Entity, (Object)((Relationship)new ArrayList(table2Entity.getRelationships()).get(0)).getTargetEntity());
    }
}

