/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.merge.builders.DataMapBuilder;
import org.apache.cayenne.dbsync.merge.builders.ObjectMother;
import org.apache.cayenne.dbsync.merge.factory.DefaultMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.CreateTableToDb;
import org.apache.cayenne.dbsync.merge.token.model.AddColumnToModel;
import org.apache.cayenne.dbsync.merge.token.model.AddRelationshipToModel;
import org.apache.cayenne.dbsync.merge.token.model.CreateTableToModel;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportModule;
import org.apache.cayenne.dbsync.reverse.dbimport.DefaultDbImportAction;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultModelMergeDelegate;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.project.FileProjectSaver;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class DefaultDbImportActionTest {
    public static final File FILE_STUB = new File(""){

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean canRead() {
            return true;
        }
    };
    private DbAdapter mockAdapter;
    private Connection mockConnection;
    private DbLoaderDelegate mockDelegate;
    private ObjectNameGenerator mockNameGenerator;

    @Before
    public void before() {
        this.mockAdapter = (DbAdapter)Mockito.mock(DbAdapter.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        this.mockDelegate = (DbLoaderDelegate)Mockito.mock(DbLoaderDelegate.class);
        this.mockNameGenerator = (ObjectNameGenerator)Mockito.mock(ObjectNameGenerator.class);
    }

    @Test
    public void testNewDataMapImport() throws Exception {
        DbImportConfiguration config = (DbImportConfiguration)Mockito.mock(DbImportConfiguration.class);
        Mockito.when((Object)config.createMergeDelegate()).thenReturn((Object)new DefaultModelMergeDelegate());
        Mockito.when((Object)config.getDbLoaderConfig()).thenReturn((Object)new DbLoaderConfiguration());
        Mockito.when((Object)config.getTargetDataMap()).thenReturn((Object)new File("xyz.map.xml"));
        Mockito.when((Object)config.createNameGenerator()).thenReturn((Object)new DefaultObjectNameGenerator(NoStemStemmer.getInstance()));
        Mockito.when((Object)config.createMeaningfulPKFilter()).thenReturn((Object)NamePatternMatcher.EXCLUDE_ALL);
        DbLoader dbLoader = new DbLoader(this.mockAdapter, this.mockConnection, config.getDbLoaderConfig(), this.mockDelegate, this.mockNameGenerator){

            @Override
            public DataMap load() throws SQLException {
                DataMap map = new DataMap();
                new DataMapBuilder(map).withDbEntities(2).build();
                return map;
            }
        };
        final boolean[] haveWeTriedToSave = new boolean[]{false};
        DefaultDbImportAction action = this.buildDbImportAction(new FileProjectSaver(Collections.emptyList()){

            public void save(Project project) {
                haveWeTriedToSave[0] = true;
                Assert.assertTrue((boolean)(project.getRootNode() instanceof DataMap));
            }
        }, null, dbLoader);
        action.execute(config);
        Assert.assertTrue((String)"We should try to save.", (boolean)haveWeTriedToSave[0]);
    }

    @Test
    public void testImportWithFieldChanged() throws Exception {
        DbImportConfiguration config = (DbImportConfiguration)Mockito.mock(DbImportConfiguration.class);
        Mockito.when((Object)config.getTargetDataMap()).thenReturn((Object)FILE_STUB);
        Mockito.when((Object)config.createMergeDelegate()).thenReturn((Object)new DefaultModelMergeDelegate());
        Mockito.when((Object)config.getDbLoaderConfig()).thenReturn((Object)new DbLoaderConfiguration());
        Mockito.when((Object)config.createNameGenerator()).thenReturn((Object)new DefaultObjectNameGenerator(NoStemStemmer.getInstance()));
        Mockito.when((Object)config.createMeaningfulPKFilter()).thenReturn((Object)NamePatternMatcher.EXCLUDE_ALL);
        DbLoader dbLoader = new DbLoader(this.mockAdapter, this.mockConnection, config.getDbLoaderConfig(), this.mockDelegate, this.mockNameGenerator){

            @Override
            public DataMap load() throws SQLException {
                DataMap dataMap = new DataMap();
                new DataMapBuilder(dataMap).with(ObjectMother.dbEntity("ARTGROUP").attributes(ObjectMother.dbAttr("GROUP_ID").typeInt().primaryKey(), ObjectMother.dbAttr("NAME").typeVarchar(100).mandatory(), ObjectMother.dbAttr("NAME_01").typeVarchar(100).mandatory(), ObjectMother.dbAttr("PARENT_GROUP_ID").typeInt())).with(ObjectMother.objEntity("org.apache.cayenne.testdo.testmap", "ArtGroup", "ARTGROUP").attributes(ObjectMother.objAttr("name").type(String.class).dbPath("NAME")));
                return dataMap;
            }
        };
        final boolean[] haveWeTriedToSave = new boolean[]{false};
        DefaultDbImportAction action = this.buildDbImportAction(new FileProjectSaver(Collections.emptyList()){

            public void save(Project project) {
                haveWeTriedToSave[0] = true;
                DataMap rootNode = (DataMap)project.getRootNode();
                Assert.assertEquals((long)1L, (long)rootNode.getObjEntities().size());
                Assert.assertEquals((long)1L, (long)rootNode.getDbEntityMap().size());
                DbEntity entity = rootNode.getDbEntity("ARTGROUP");
                Assert.assertNotNull((Object)entity);
                Assert.assertEquals((long)4L, (long)entity.getAttributes().size());
                Assert.assertNotNull((Object)entity.getAttribute("NAME_01"));
            }
        }, new DataMapLoader(){

            public DataMap load(Resource configurationResource) throws CayenneRuntimeException {
                return new DataMapBuilder().with(ObjectMother.dbEntity("ARTGROUP").attributes(ObjectMother.dbAttr("GROUP_ID").typeInt().primaryKey(), ObjectMother.dbAttr("NAME").typeVarchar(100).mandatory(), ObjectMother.dbAttr("PARENT_GROUP_ID").typeInt())).with(ObjectMother.objEntity("org.apache.cayenne.testdo.testmap", "ArtGroup", "ARTGROUP").attributes(ObjectMother.objAttr("name").type(String.class).dbPath("NAME"))).build();
            }
        }, dbLoader);
        action.execute(config);
        Assert.assertTrue((String)"We should try to save.", (boolean)haveWeTriedToSave[0]);
    }

    @Test
    public void testImportWithoutChanges() throws Exception {
        DbImportConfiguration config = (DbImportConfiguration)Mockito.mock(DbImportConfiguration.class);
        Mockito.when((Object)config.getTargetDataMap()).thenReturn((Object)FILE_STUB);
        Mockito.when((Object)config.createMergeDelegate()).thenReturn((Object)new DefaultModelMergeDelegate());
        Mockito.when((Object)config.getDbLoaderConfig()).thenReturn((Object)new DbLoaderConfiguration());
        DbLoader dbLoader = new DbLoader(this.mockAdapter, this.mockConnection, config.getDbLoaderConfig(), this.mockDelegate, this.mockNameGenerator){

            @Override
            public DataMap load() throws SQLException {
                DataMap dataMap = new DataMap();
                new DataMapBuilder(dataMap).with(ObjectMother.dbEntity("ARTGROUP").attributes(ObjectMother.dbAttr("NAME").typeVarchar(100).mandatory()));
                return dataMap;
            }
        };
        FileProjectSaver projectSaver = (FileProjectSaver)Mockito.mock(FileProjectSaver.class);
        ((FileProjectSaver)Mockito.doNothing().when((Object)projectSaver)).save((Project)ArgumentMatchers.any(Project.class));
        DataMapLoader mapLoader = (DataMapLoader)Mockito.mock(DataMapLoader.class);
        Mockito.when((Object)mapLoader.load((Resource)ArgumentMatchers.any(Resource.class))).thenReturn((Object)new DataMapBuilder().with(ObjectMother.dbEntity("ARTGROUP").attributes(ObjectMother.dbAttr("NAME").typeVarchar(100).mandatory())).build());
        DefaultDbImportAction action = this.buildDbImportAction(projectSaver, mapLoader, dbLoader);
        action.execute(config);
        ((FileProjectSaver)Mockito.verify((Object)projectSaver, (VerificationMode)Mockito.never())).save((Project)ArgumentMatchers.any(Project.class));
        ((DataMapLoader)Mockito.verify((Object)mapLoader, (VerificationMode)Mockito.times((int)1))).load((Resource)ArgumentMatchers.any(Resource.class));
    }

    @Test
    public void testImportWithDbError() throws Exception {
        DbLoader dbLoader = (DbLoader)Mockito.mock(DbLoader.class);
        ((DbLoader)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)dbLoader)).load();
        DbImportConfiguration params = (DbImportConfiguration)Mockito.mock(DbImportConfiguration.class);
        FileProjectSaver projectSaver = (FileProjectSaver)Mockito.mock(FileProjectSaver.class);
        ((FileProjectSaver)Mockito.doNothing().when((Object)projectSaver)).save((Project)ArgumentMatchers.any(Project.class));
        DataMapLoader mapLoader = (DataMapLoader)Mockito.mock(DataMapLoader.class);
        Mockito.when((Object)mapLoader.load((Resource)ArgumentMatchers.any(Resource.class))).thenReturn(null);
        DefaultDbImportAction action = this.buildDbImportAction(projectSaver, mapLoader, dbLoader);
        try {
            action.execute(params);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((FileProjectSaver)Mockito.verify((Object)projectSaver, (VerificationMode)Mockito.never())).save((Project)ArgumentMatchers.any(Project.class));
        ((DataMapLoader)Mockito.verify((Object)mapLoader, (VerificationMode)Mockito.never())).load((Resource)ArgumentMatchers.any(Resource.class));
    }

    private DefaultDbImportAction buildDbImportAction(FileProjectSaver projectSaver, DataMapLoader mapLoader, final DbLoader dbLoader) throws Exception {
        Logger log = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)log.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)log.isInfoEnabled()).thenReturn((Object)true);
        DbAdapter dbAdapter = (DbAdapter)Mockito.mock(DbAdapter.class);
        DbAdapterFactory adapterFactory = (DbAdapterFactory)Mockito.mock(DbAdapterFactory.class);
        Mockito.when((Object)adapterFactory.createAdapter((DataNodeDescriptor)ArgumentMatchers.any(), (DataSource)ArgumentMatchers.any())).thenReturn((Object)dbAdapter);
        DataSourceFactory dataSourceFactory = (DataSourceFactory)Mockito.mock(DataSourceFactory.class);
        DataSource mock = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSourceFactory.getDataSource((DataNodeDescriptor)ArgumentMatchers.any())).thenReturn((Object)mock);
        MergerTokenFactoryProvider mergerTokenFactoryProvider = (MergerTokenFactoryProvider)((Object)Mockito.mock(MergerTokenFactoryProvider.class));
        Mockito.when((Object)mergerTokenFactoryProvider.get((DbAdapter)ArgumentMatchers.any())).thenReturn((Object)new DefaultMergerTokenFactory());
        return new DefaultDbImportAction(log, (ProjectSaver)projectSaver, dataSourceFactory, adapterFactory, mapLoader, mergerTokenFactoryProvider){

            @Override
            protected DbLoader createDbLoader(DbAdapter adapter, Connection connection, DbImportConfiguration config) {
                return dbLoader;
            }
        };
    }

    @Test
    public void testSaveLoaded() throws Exception {
        Logger log = (Logger)Mockito.mock(Logger.class);
        Injector i = DIBootstrap.createInjector((Module[])new Module[]{new DbSyncModule(), new ToolsModule(log), new DbImportModule()});
        DefaultDbImportAction action = (DefaultDbImportAction)i.getInstance(DbImportAction.class);
        String packagePath = this.getClass().getPackage().getName().replace('.', '/');
        URL packageUrl = this.getClass().getClassLoader().getResource(packagePath);
        Assert.assertNotNull((Object)packageUrl);
        URL outUrl = new URL(packageUrl, "dbimport/testSaveLoaded1.map.xml");
        File out = new File(outUrl.toURI());
        out.delete();
        Assert.assertFalse((boolean)out.isFile());
        DataMap map = new DataMap("testSaveLoaded1");
        map.setConfigurationSource((Resource)new URLResource(outUrl));
        action.saveLoaded(map);
        Assert.assertTrue((boolean)out.isFile());
        String contents = Util.stringFromFile((File)out);
        Assert.assertTrue((String)"Has no project version saved", (boolean)contents.contains("project-version=\""));
    }

    @Test
    public void testMergeTokensSorting() {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        tokens.add(new AddColumnToModel(null, null));
        tokens.add(new AddRelationshipToModel(null, null));
        tokens.add(new CreateTableToDb(null));
        tokens.add(new CreateTableToModel(null));
        Assert.assertEquals(Arrays.asList("CreateTableToDb", "CreateTableToModel", "AddColumnToModel", "AddRelationshipToModel"), this.toClasses(DefaultDbImportAction.sort(tokens)));
    }

    private List<String> toClasses(List<MergerToken> sort) {
        LinkedList<String> res = new LinkedList<String>();
        for (MergerToken mergerToken : sort) {
            res.add(mergerToken.getClass().getSimpleName());
        }
        return res;
    }
}

