/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.configuration;

import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dbsync.reverse.configuration.DriverDataSourceFactory;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class ToolsModuleTest {
    @Test
    public void testModuleContents() {
        Logger log = (Logger)Mockito.mock(Logger.class);
        Injector i = DIBootstrap.createInjector((Module[])new Module[]{new ToolsModule(log)});
        Assert.assertSame((Object)log, (Object)i.getInstance(Logger.class));
        Assert.assertTrue((boolean)(i.getInstance(DataSourceFactory.class) instanceof DriverDataSourceFactory));
        Assert.assertTrue((boolean)(i.getInstance(AdhocObjectFactory.class) instanceof DefaultAdhocObjectFactory));
        Assert.assertTrue((boolean)(i.getInstance(DbAdapterFactory.class) instanceof DefaultDbAdapterFactory));
    }

    @Test
    public void testDbApdater() throws Exception {
        Logger log = (Logger)Mockito.mock(Logger.class);
        Injector i = DIBootstrap.createInjector((Module[])new Module[]{new ToolsModule(log)});
        DbAdapterFactory factory = (DbAdapterFactory)i.getInstance(DbAdapterFactory.class);
        DataNodeDescriptor nodeDescriptor = (DataNodeDescriptor)Mockito.mock(DataNodeDescriptor.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Assert.assertTrue((boolean)(factory.createAdapter(nodeDescriptor, dataSource) instanceof AutoAdapter));
    }
}

