/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class NameBuilderTest {
    @Test
    public void testName_Root() {
        Assert.assertEquals((Object)"project", (Object)NameBuilder.builder((ConfigurationNode)new DataChannelDescriptor()).name());
    }

    @Test
    public void testName_DataChannelDescriptorContext() throws Exception {
        DataChannelDescriptor descriptor = new DataChannelDescriptor();
        DataMap m0 = new DataMap();
        m0.setName(NameBuilder.builder((ConfigurationNode)m0).in((ConfigurationNode)descriptor).name());
        Assert.assertEquals((Object)"datamap", (Object)m0.getName());
        descriptor.getDataMaps().add(m0);
        DataMap m1 = new DataMap();
        m1.setName(NameBuilder.builder((ConfigurationNode)m1).in((ConfigurationNode)descriptor).name());
        Assert.assertEquals((Object)"datamap1", (Object)m1.getName());
        descriptor.getDataMaps().add(m1);
        DataNodeDescriptor nd0 = new DataNodeDescriptor();
        nd0.setName(NameBuilder.builder((ConfigurationNode)nd0).in((ConfigurationNode)descriptor).name());
        Assert.assertEquals((Object)"datanode", (Object)nd0.getName());
        descriptor.getNodeDescriptors().add(nd0);
        DataNodeDescriptor nd1 = new DataNodeDescriptor();
        nd1.setName(NameBuilder.builder((ConfigurationNode)nd1).in((ConfigurationNode)descriptor).name());
        Assert.assertEquals((Object)"datanode1", (Object)nd1.getName());
        descriptor.getNodeDescriptors().add(nd1);
    }

    @Test
    public void testName_DataMapContext() {
        DataMap map = new DataMap();
        map.setDefaultPackage("com.foo");
        DbEntity de0 = new DbEntity();
        de0.setName(NameBuilder.builder((ConfigurationNode)de0).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"db_entity", (Object)de0.getName());
        map.addDbEntity(de0);
        DbEntity de1 = new DbEntity();
        de1.setName(NameBuilder.builder((ConfigurationNode)de1).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"db_entity1", (Object)de1.getName());
        map.addDbEntity(de1);
        ObjEntity oe0 = new ObjEntity();
        oe0.setName(NameBuilder.builder((ConfigurationNode)oe0).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"ObjEntity", (Object)oe0.getName());
        map.addObjEntity(oe0);
        ObjEntity oe1 = new ObjEntity();
        oe1.setName(NameBuilder.builder((ConfigurationNode)oe1).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"ObjEntity1", (Object)oe1.getName());
        map.addObjEntity(oe1);
        ObjEntity oe2 = new ObjEntity();
        oe2.setName(NameBuilder.builder((ConfigurationNode)oe0).in((ConfigurationNode)map).baseName("db_entity").name());
        Assert.assertEquals((String)"Should not conflict with similarly named DbEntity", (Object)"Db_entity", (Object)oe2.getName());
        map.addObjEntity(oe2);
        Procedure p0 = new Procedure();
        p0.setName(NameBuilder.builder((ConfigurationNode)p0).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"procedure", (Object)p0.getName());
        map.addProcedure(p0);
        Procedure p1 = new Procedure();
        p1.setName(NameBuilder.builder((ConfigurationNode)p1).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"procedure1", (Object)p1.getName());
        map.addProcedure(p1);
        Procedure p2 = new Procedure();
        p2.setName(NameBuilder.builder((ConfigurationNode)p1).in((ConfigurationNode)map).baseName("db_enity").name());
        Assert.assertEquals((String)"Should not conflict with similarly named DbEntity", (Object)"db_enity", (Object)p2.getName());
        map.addProcedure(p2);
        SelectQueryDescriptor q0 = QueryDescriptor.selectQueryDescriptor();
        q0.setName(NameBuilder.builder((ConfigurationNode)q0).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"query", (Object)q0.getName());
        map.addQueryDescriptor((QueryDescriptor)q0);
        EJBQLQueryDescriptor q1 = QueryDescriptor.ejbqlQueryDescriptor();
        q1.setName(NameBuilder.builder((ConfigurationNode)q1).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"query1", (Object)q1.getName());
        map.addQueryDescriptor((QueryDescriptor)q1);
        Embeddable e0 = new Embeddable();
        e0.setClassName("com.foo." + NameBuilder.builder((ConfigurationNode)e0).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"com.foo.Embeddable", (Object)e0.getClassName());
        map.addEmbeddable(e0);
        Embeddable e1 = new Embeddable();
        e1.setClassName("com.foo." + NameBuilder.builder((ConfigurationNode)e1).in((ConfigurationNode)map).name());
        Assert.assertEquals((Object)"com.foo.Embeddable1", (Object)e1.getClassName());
        map.addEmbeddable(e1);
    }

    @Test
    public void testName_ObjEntityContext() {
        ObjEntity entity = new ObjEntity();
        entity.getCallbackMap().getPostAdd().addCallbackMethod("getMe");
        ObjAttribute a0 = new ObjAttribute();
        String na0 = NameBuilder.builder((ConfigurationNode)a0).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledAttr", (Object)na0);
        a0.setName(na0);
        entity.addAttribute((Attribute)a0);
        ObjAttribute a1 = new ObjAttribute();
        String na1 = NameBuilder.builder((ConfigurationNode)a1).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledAttr1", (Object)na1);
        a1.setName(na1);
        entity.addAttribute((Attribute)a1);
        ObjAttribute a2 = new ObjAttribute();
        String na2 = NameBuilder.builder((ConfigurationNode)a2).in((ConfigurationNode)entity).baseName("me").name();
        Assert.assertEquals((String)"Conflict with callback method was not detected", (Object)"me1", (Object)na2);
        a2.setName(na2);
        entity.addAttribute((Attribute)a2);
        ObjRelationship r0 = new ObjRelationship();
        String nr0 = NameBuilder.builder((ConfigurationNode)r0).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledRel", (Object)nr0);
        r0.setName(nr0);
        entity.addRelationship((Relationship)r0);
        ObjRelationship r1 = new ObjRelationship();
        String nr1 = NameBuilder.builder((ConfigurationNode)r1).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledRel1", (Object)nr1);
        r1.setName(nr1);
        entity.addRelationship((Relationship)r1);
    }

    @Test
    public void testName_DbEntityContext() {
        DbEntity entity = new DbEntity();
        DbAttribute a0 = new DbAttribute();
        String na0 = NameBuilder.builder((ConfigurationNode)a0).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledAttr", (Object)na0);
        a0.setName(na0);
        entity.addAttribute(a0);
        DbAttribute a1 = new DbAttribute();
        String na1 = NameBuilder.builder((ConfigurationNode)a1).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledAttr1", (Object)na1);
        a1.setName(na1);
        entity.addAttribute(a1);
        DbRelationship r0 = new DbRelationship();
        String nr0 = NameBuilder.builder((ConfigurationNode)r0).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledRel", (Object)nr0);
        r0.setName(nr0);
        entity.addRelationship((Relationship)r0);
        DbRelationship r1 = new DbRelationship();
        String nr1 = NameBuilder.builder((ConfigurationNode)r1).in((ConfigurationNode)entity).name();
        Assert.assertEquals((Object)"untitledRel1", (Object)nr1);
        r1.setName(nr1);
        entity.addRelationship((Relationship)r1);
    }

    @Test
    public void testName_ProcedureContext() {
        Procedure procedure = new Procedure();
        ProcedureParameter p0 = new ProcedureParameter();
        p0.setName(NameBuilder.builder((ConfigurationNode)p0).in((ConfigurationNode)procedure).name());
        Assert.assertEquals((Object)"UntitledProcedureParameter", (Object)p0.getName());
        procedure.addCallParameter(p0);
        ProcedureParameter p1 = new ProcedureParameter();
        p1.setName(NameBuilder.builder((ConfigurationNode)p1).in((ConfigurationNode)procedure).name());
        Assert.assertEquals((Object)"UntitledProcedureParameter1", (Object)p1.getName());
        procedure.addCallParameter(p1);
    }

    @Test
    public void testName_EmbeddableContext() {
        Embeddable embeddable = new Embeddable();
        EmbeddableAttribute ea0 = new EmbeddableAttribute();
        ea0.setName(NameBuilder.builder((ConfigurationNode)ea0).in((ConfigurationNode)embeddable).name());
        Assert.assertEquals((Object)"untitledAttr", (Object)ea0.getName());
        embeddable.addAttribute(ea0);
        EmbeddableAttribute ea1 = new EmbeddableAttribute();
        ea1.setName(NameBuilder.builder((ConfigurationNode)ea1).in((ConfigurationNode)embeddable).name());
        Assert.assertEquals((Object)"untitledAttr1", (Object)ea1.getName());
        embeddable.addAttribute(ea1);
    }

    @Test
    public void testName_UncapitalizeAttributeNames() throws Exception {
        ObjEntity entity = new ObjEntity();
        ObjAttribute a0 = new ObjAttribute();
        String na0 = NameBuilder.builder((ConfigurationNode)a0).in((ConfigurationNode)entity).baseName("myName").name();
        Assert.assertEquals((Object)"myName", (Object)na0);
        a0.setName(na0);
        entity.addAttribute((Attribute)a0);
        ObjAttribute a1 = new ObjAttribute();
        String na1 = NameBuilder.builder((ConfigurationNode)a1).in((ConfigurationNode)entity).baseName("MyName").name();
        Assert.assertEquals((Object)"myName1", (Object)na1);
        a1.setName(na1);
        entity.addAttribute((Attribute)a1);
    }

    @Test
    public void testName_Callbacks_ObjEntityContext() {
        ObjEntity entity = new ObjEntity();
        String c0 = NameBuilder.builderForCallbackMethod(entity).name();
        Assert.assertEquals((Object)"onEvent", (Object)c0);
        entity.getCallbackMap().getPostAdd().addCallbackMethod(c0);
        String c1 = NameBuilder.builderForCallbackMethod(entity).name();
        Assert.assertEquals((Object)"onEvent1", (Object)c1);
        entity.getCallbackMap().getPostAdd().addCallbackMethod(c1);
        entity.addAttribute((Attribute)new ObjAttribute("untitledAttr"));
        String c3 = NameBuilder.builderForCallbackMethod(entity).baseName("getUntitledAttr").name();
        Assert.assertEquals((Object)"getUntitledAttr1", (Object)c3);
        entity.getCallbackMap().getPostAdd().addCallbackMethod(c3);
    }
}

