/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import java.util.List;
import org.apache.cayenne.dbsync.merge.MergeCase;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.CreateTableToModel;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.junit.Assert;
import org.junit.Test;

public class CreateTableToModelIT
extends MergeCase {
    @Test
    public void testAddTable() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        DbAttribute column1 = new DbAttribute("ID", 4, dbEntity);
        column1.setMandatory(true);
        column1.setPrimaryKey(true);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NAME", 12, dbEntity);
        column2.setMaxLength(10);
        column2.setMandatory(false);
        dbEntity.addAttribute(column2);
        this.execute(this.mergerFactory().createCreateTableToDb(dbEntity));
        List<MergerToken> tokens = this.createMergeTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        MergerToken token = tokens.get(0);
        if (token.getDirection().isToDb()) {
            token = token.createReverse(this.mergerFactory());
        }
        Assert.assertTrue((String)token.getClass().getName(), (boolean)(token instanceof CreateTableToModel));
        this.execute(token);
        ObjEntity objEntity = null;
        for (ObjEntity candidate : this.map.getObjEntities()) {
            if (!dbEntity.getName().equalsIgnoreCase(candidate.getDbEntityName())) continue;
            objEntity = candidate;
            break;
        }
        Assert.assertNotNull(objEntity);
        Assert.assertEquals((Object)objEntity.getClassName(), (Object)(this.map.getDefaultPackage() + "." + objEntity.getName()));
        Assert.assertEquals((Object)objEntity.getSuperClassName(), (Object)this.map.getDefaultSuperclass());
        Assert.assertEquals((Object)objEntity.getClientClassName(), (Object)(this.map.getDefaultClientPackage() + "." + objEntity.getName()));
        Assert.assertEquals((Object)objEntity.getClientSuperClassName(), (Object)this.map.getDefaultClientSuperclass());
        Assert.assertEquals((long)1L, (long)objEntity.getAttributes().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)((ObjAttribute)objEntity.getAttributes().iterator().next()).getType());
        this.map.removeDbEntity(objEntity.getDbEntity().getName(), true);
        this.map.removeObjEntity(objEntity.getName(), true);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }
}

