/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.MergeCase;
import org.apache.cayenne.dbsync.merge.token.DefaultValueForNullProvider;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.junit.Assert;
import org.junit.Test;

public class ValueForNullIT
extends MergeCase {
    private static final String DEFAULT_VALUE_STRING = "DEFSTRING";
    @Inject
    private DataContext context;

    @Test
    public void test() throws Exception {
        DbEntity dbEntity = this.map.getDbEntity("PAINTING");
        Assert.assertNotNull((Object)dbEntity);
        ObjEntity objEntity = this.map.getObjEntity("Painting");
        Assert.assertNotNull((Object)objEntity);
        int nrows = 10;
        for (int i = 0; i < 10; ++i) {
            DataObject o = (DataObject)this.context.newObject("Painting");
            o.writeProperty("paintingTitle", (Object)("ptitle" + i));
        }
        this.context.commitChanges();
        DbAttribute column = new DbAttribute("NEWCOL2", 12, dbEntity);
        column.setMandatory(false);
        column.setMaxLength(10);
        dbEntity.addAttribute(column);
        Assert.assertTrue((boolean)dbEntity.getAttributes().contains(column));
        Assert.assertEquals((Object)column, (Object)dbEntity.getAttribute(column.getName()));
        this.assertTokensAndExecute(1, 0);
        ObjAttribute objAttr = new ObjAttribute("newcol2");
        objAttr.setDbAttributePath(column.getName());
        objEntity.addAttribute((Attribute)objAttr);
        this.assertTokensAndExecute(0, 0);
        column.setMandatory(true);
        this.assertTokensAndExecute(2, 0);
        this.assertTokensAndExecute(0, 0);
        Expression qual = ExpressionFactory.matchExp((String)objAttr.getName(), (Object)DEFAULT_VALUE_STRING);
        SelectQuery query = new SelectQuery("Painting", qual);
        List rows = this.context.performQuery((Query)query);
        Assert.assertEquals((long)10L, (long)rows.size());
        dbEntity.removeAttribute(column.getName());
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }

    @Override
    protected DataMapMerger.Builder merger() {
        return super.merger().valueForNullProvider(new DefaultValueForNullProvider(){

            @Override
            protected ParameterBinding get(DbEntity entity, DbAttribute column) {
                int type = column.getType();
                switch (type) {
                    case 12: {
                        return new ParameterBinding((Object)ValueForNullIT.DEFAULT_VALUE_STRING, Integer.valueOf(type), -1);
                    }
                }
                throw new AssertionFailedError("should not get here");
            }

            @Override
            public boolean hasValueFor(DbEntity entity, DbAttribute column) {
                return true;
            }
        });
    }
}

