/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.builders;

import org.apache.cayenne.datafactory.DictionaryValueProvider;
import org.apache.cayenne.datafactory.ValueProvider;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.merge.builders.DefaultBuilder;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.Util;

public class DbAttributeBuilder
extends DefaultBuilder<DbAttribute> {
    private static final ValueProvider<String> TYPES_RANDOM = new DictionaryValueProvider<String>(ValueProvider.RANDOM){

        protected String[] values() {
            return TypesMapping.getDatabaseTypes();
        }
    };

    public DbAttributeBuilder() {
        super(new DbAttribute());
    }

    public DbAttributeBuilder name() {
        return this.name(this.getRandomJavaName());
    }

    public DbAttributeBuilder name(String name) {
        ((DbAttribute)this.obj).setName(name);
        return this;
    }

    public DbAttributeBuilder type() {
        return this.type((String)TYPES_RANDOM.randomValue());
    }

    public DbAttributeBuilder type(String item) {
        ((DbAttribute)this.obj).setType(TypesMapping.getSqlTypeByName((String)item));
        return this;
    }

    public DbAttributeBuilder typeInt() {
        return this.type("INTEGER");
    }

    public DbAttributeBuilder typeBigInt() {
        return this.type("BIGINT");
    }

    public DbAttributeBuilder typeVarchar(int length) {
        this.type("VARCHAR");
        this.length(length);
        return this;
    }

    private DbAttributeBuilder length(int length) {
        ((DbAttribute)this.obj).setMaxLength(length);
        return this;
    }

    public DbAttributeBuilder primaryKey() {
        ((DbAttribute)this.obj).setPrimaryKey(true);
        return this;
    }

    public DbAttributeBuilder mandatory() {
        ((DbAttribute)this.obj).setMandatory(true);
        return this;
    }

    public DbAttributeBuilder generated() {
        ((DbAttribute)this.obj).setGenerated(true);
        return this;
    }

    @Override
    public DbAttribute build() {
        if (Util.isEmptyString((String)((DbAttribute)this.obj).getName())) {
            this.name();
        }
        if (((DbAttribute)this.obj).getType() == Integer.MAX_VALUE) {
            this.type();
        }
        return (DbAttribute)this.obj;
    }

    @Override
    public DbAttribute random() {
        return this.build();
    }
}

