/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.commons.applib.services.menu;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuUiService;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;

public class MenuUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final DomainServiceLayout.MenuBar menuBarSelect;
    @NonNull
    private final List<String> menuContributingServiceIds;

    public String getCssClass() {
        return this.menuBarSelect.name().toLowerCase(Locale.ENGLISH);
    }

    public void buildMenuItems(MetaModelContext mmc, MenuVisitor menuBuilder) {
        this.buildMenuItems((MenuUiService)mmc.getServiceRegistry().lookupServiceElseFail(MenuUiService.class), menuBuilder);
    }

    public void buildMenuItems(MenuUiService menuUiService, MenuVisitor menuBuilder) {
        menuUiService.buildMenuItems(this, menuBuilder);
    }

    @NonNull
    public DomainServiceLayout.MenuBar getMenuBarSelect() {
        return this.menuBarSelect;
    }

    @NonNull
    public List<String> getMenuContributingServiceIds() {
        return this.menuContributingServiceIds;
    }

    private MenuUiModel(@NonNull DomainServiceLayout.MenuBar menuBarSelect, @NonNull List<String> menuContributingServiceIds) {
        if (menuBarSelect == null) {
            throw new NullPointerException("menuBarSelect is marked non-null but is null");
        }
        if (menuContributingServiceIds == null) {
            throw new NullPointerException("menuContributingServiceIds is marked non-null but is null");
        }
        this.menuBarSelect = menuBarSelect;
        this.menuContributingServiceIds = menuContributingServiceIds;
    }

    public static MenuUiModel of(@NonNull DomainServiceLayout.MenuBar menuBarSelect, @NonNull List<String> menuContributingServiceIds) {
        if (menuBarSelect == null) {
            throw new NullPointerException("menuBarSelect is marked non-null but is null");
        }
        if (menuContributingServiceIds == null) {
            throw new NullPointerException("menuContributingServiceIds is marked non-null but is null");
        }
        return new MenuUiModel(menuBarSelect, menuContributingServiceIds);
    }
}

