/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.matchers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class JaxbUtil2 {
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = new ConcurrentHashMap();

    private JaxbUtil2() {
    }

    static <T> String toXml(T dto) {
        CharArrayWriter caw = new CharArrayWriter();
        JaxbUtil2.toXml(dto, caw);
        return caw.toString();
    }

    static <T> void toXml(T dto, Writer writer) {
        try {
            Class<?> aClass = dto.getClass();
            Marshaller m = JaxbUtil2.jaxbContextFor(aClass).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(dto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> JAXBContext jaxbContextFor(Class<T> dtoClass) {
        JAXBContext jaxbContext = jaxbContextByClass.get(dtoClass);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{dtoClass});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            jaxbContextByClass.put(dtoClass, jaxbContext);
        }
        return jaxbContext;
    }
}

