/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.unittestsupport.applib.matchers;

import java.util.Objects;
import org.apache.causeway.testing.unittestsupport.applib.matchers.JaxbUtil2;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class JaxbMatchers {
    private JaxbMatchers() {
    }

    public static <T> Matcher<? super T> isEquivalentTo(final T expected) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                String expectedXml = JaxbUtil2.toXml(expected);
                String itemXml = JaxbUtil2.toXml(item);
                return Objects.equals(expectedXml, itemXml);
            }

            public void describeTo(Description description) {
                String expectedXml = JaxbUtil2.toXml(expected);
                description.appendText("is equivalent to ").appendValue((Object)expectedXml);
            }
        };
    }
}

