/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.specsupport.applib.integration;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.commons.internal.collections._Maps;

public class ObjectFactoryForIntegration
implements ObjectFactory {
    private final ServiceInjector serviceInjector;
    private final Map<Class<?>, Object> instances = _Maps.newHashMap();

    public void start() {
    }

    public void stop() {
        this.instances.clear();
    }

    public boolean addClass(Class<?> clazz) {
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        T instance = type.cast(this.instances.get(type));
        if (instance == null) {
            instance = this.newInstance(type);
            if (this.serviceInjector != null) {
                instance = this.cacheInstance(type, instance);
                this.serviceInjector.injectServicesInto(instance);
            }
        }
        return instance;
    }

    private <T> T cacheInstance(Class<T> type, T instance) {
        this.instances.put(type, instance);
        return instance;
    }

    private <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException var4) {
            throw new CucumberException(String.format("%s doesn't have an empty constructor.", type), (Throwable)var4);
        }
        catch (Exception var5) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)var5);
        }
    }

    public ObjectFactoryForIntegration(ServiceInjector serviceInjector) {
        this.serviceInjector = serviceInjector;
    }
}

