/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.integtestsupport.applib.validate;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.exceptions.unrecoverable.DomainModelException;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.registry.ServiceRegistry;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.core.config.metamodel.specloader.IntrospectionMode;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.causeway.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;
import org.springframework.lang.Nullable;

public class DomainModelValidator {
    private static final Logger log = LogManager.getLogger(DomainModelValidator.class);
    private final ValidationFailures validationFailures;
    private final SpecificationLoader specificationLoader;

    @Inject
    public DomainModelValidator(ServiceRegistry registry) {
        this((SpecificationLoader)registry.lookupServiceElseFail(SpecificationLoader.class), (CausewayConfiguration)registry.lookupServiceElseFail(CausewayConfiguration.class), (CausewaySystemEnvironment)registry.lookupServiceElseFail(CausewaySystemEnvironment.class));
    }

    public DomainModelValidator(SpecificationLoader specificationLoader, CausewayConfiguration configuration, CausewaySystemEnvironment causewaySystemEnvironment) {
        boolean recreateRequired = DomainModelValidator.isRecreateRequired(configuration, causewaySystemEnvironment);
        if (recreateRequired) {
            specificationLoader.createMetaModel();
            if (log.isDebugEnabled()) {
                specificationLoader.forEach(spec -> log.debug("loaded: " + spec.getFullIdentifier()));
            }
        }
        this.specificationLoader = specificationLoader;
        this.validationFailures = specificationLoader.getOrAssessValidationResult();
    }

    private static boolean isRecreateRequired(CausewayConfiguration configuration, CausewaySystemEnvironment causewaySystemEnvironment) {
        IntrospectionMode mode = configuration.getCore().getMetaModel().getIntrospector().getMode();
        switch (mode) {
            case FULL: {
                return false;
            }
            case LAZY_UNLESS_PRODUCTION: {
                return causewaySystemEnvironment.isPrototyping();
            }
        }
        return true;
    }

    public void assertValid() {
        if (this.validationFailures.hasFailures()) {
            StringJoiner joiner = new StringJoiner("\n");
            this.validationFailures.getMessages().forEach(joiner::add);
            Assertions.fail((String)joiner.toString());
        }
    }

    public void throwIfInvalid() {
        if (this.validationFailures.hasFailures()) {
            this.throwFailureException(this.validationFailures.getNumberOfFailures() + " problems found.", this.validationFailures.getMessages());
        }
    }

    public Set<ValidationFailure> getFailures() {
        if (this.validationFailures == null) {
            return Collections.emptySet();
        }
        return this.validationFailures.getFailures();
    }

    public Stream<ValidationFailure> streamFailures(@Nullable Predicate<Identifier> filter) {
        if (this.validationFailures == null) {
            return Stream.empty();
        }
        if (filter == null) {
            return this.validationFailures.getFailures().stream();
        }
        return this.validationFailures.getFailures().stream().filter(failure -> filter.test(failure.getOrigin()));
    }

    public Stream<ValidationFailure> streamFailuresMatchingOriginatingIdentifier(@NonNull Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        return this.streamFailures(id -> id.equals((Object)identifier));
    }

    public void assertAnyFailuresContaining(@NonNull Identifier identifier, @NonNull String messageSnippet) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (messageSnippet == null) {
            throw new NullPointerException("messageSnippet is marked non-null but is null");
        }
        boolean matchFound = this.streamFailuresMatchingOriginatingIdentifier(identifier).anyMatch(failure -> failure.getMessage().contains(messageSnippet));
        if (!matchFound) {
            String msg = String.format("validation snipped '%s' not found within messages:\n%s", messageSnippet, this.streamFailuresMatchingOriginatingIdentifier(identifier).map(ValidationFailure::getMessage).collect(Collectors.joining("\n")));
            throw new AssertionFailedError(msg);
        }
    }

    public void assertAnyFailuresContaining(@NonNull Class<?> domainType, @NonNull String messageSnippet) {
        if (domainType == null) {
            throw new NullPointerException("domainType is marked non-null but is null");
        }
        if (messageSnippet == null) {
            throw new NullPointerException("messageSnippet is marked non-null but is null");
        }
        LogicalType logicalType = this.specificationLoader.specForTypeElseFail(domainType).getLogicalType();
        Predicate<Identifier> filterByLogicalType = id -> id.getLogicalType().equals((Object)logicalType);
        boolean matchFound = this.streamFailures(filterByLogicalType).anyMatch(failure -> failure.getMessage().contains(messageSnippet));
        if (!matchFound) {
            String msg = String.format("validation snipped '%s' not found within messages:\n%s", messageSnippet, this.streamFailures(filterByLogicalType).map(ValidationFailure::getMessage).collect(Collectors.joining("\n")));
            throw new AssertionFailedError(msg);
        }
    }

    public void assertAnyOfContainingAnyFailures(Can<Identifier> classIdentifiers, String messageSnippet) {
        boolean matchFound = classIdentifiers.stream().anyMatch(identifier -> this.streamFailuresMatchingOriginatingIdentifier((Identifier)identifier).anyMatch(failure -> failure.getMessage().contains(messageSnippet)));
        if (!matchFound) {
            String msg = String.format("validation snipped '%s' not found within messages:\n%s", messageSnippet, classIdentifiers.stream().flatMap(identifier -> this.streamFailuresMatchingOriginatingIdentifier((Identifier)identifier)).map(ValidationFailure::getMessage).collect(Collectors.joining("\n")));
            throw new AssertionFailedError(msg);
        }
    }

    private void throwFailureException(String errorMessage, Collection<String> logMessages) {
        this.logErrors(logMessages);
        throw new DomainModelException(errorMessage);
    }

    private void logErrors(Collection<String> logMessages) {
        log.error("### Domain Model Deficiencies");
        for (String logMessage : logMessages) {
            log.error(logMessage);
        }
    }
}

