/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.integtestsupport.applib;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.causeway.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.commons.internal.reflection._Annotations;
import org.apache.causeway.testing.integtestsupport.applib.CausewayIntegrationTestAbstract;
import org.apache.causeway.testing.integtestsupport.applib.annotation.InteractAs;
import org.apache.causeway.testing.integtestsupport.applib.annotation.InteractAsUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.context.ApplicationContext;

class _Helper {
    _Helper() {
    }

    static Optional<ApplicationContext> getSpringContext(ExtensionContext extensionContext) {
        return extensionContext.getTestInstance().filter(CausewayIntegrationTestAbstract.class::isInstance).map(CausewayIntegrationTestAbstract.class::cast).map(causewayIntegrationTestAbstract -> causewayIntegrationTestAbstract.springContext);
    }

    static <T> Optional<T> lookup(Class<T> requiredType, ExtensionContext extensionContext) {
        return _Helper.getSpringContext(extensionContext).map(springContext -> springContext.getBean(requiredType));
    }

    static Optional<InteractionContext> getCustomInteractionContext(ExtensionContext extensionContext) {
        return extensionContext.getTestMethod().flatMap(testMethod -> _Annotations.synthesizeConsideringClass((Method)testMethod, InteractAs.class)).map(InteractAsUtils::toInteractionContext);
    }

    static Optional<InteractionService> getInteractionFactory(ExtensionContext extensionContext) {
        return _Helper.lookup(InteractionService.class, extensionContext);
    }

    static Optional<ExceptionRecognizerService> getExceptionRecognizerService(ExtensionContext extensionContext) {
        return _Helper.lookup(ExceptionRecognizerService.class, extensionContext);
    }
}

