/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.testing.integtestsupport.applib;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.commons.io.TextUtils;
import org.approvaltests.core.Options;
import org.approvaltests.core.Scrubber;

public final class ApprovalsOptions {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static Options xmlOptions() {
        return new Options().withScrubber(ApprovalsOptions::scrub).forFile().withExtension(".xml");
    }

    private static String scrub(String input) {
        return TextUtils.streamLines((String)input).map(ApprovalsOptions::scrubLine).filter(line -> !_Strings.nullToEmpty((String)line).isBlank()).collect(Collectors.joining("\n"));
    }

    private static String scrubLine(String line) {
        String magicPrefix = "<mml:param ";
        String magicSuffix = ">";
        int p = line.indexOf("<mml:param ");
        if (p < 0) {
            return line;
        }
        int q = line.lastIndexOf(">");
        ArrayList chunks = _Lists.newArrayList();
        chunks.add(line.substring(0, (p += "<mml:param ".length()) - 1));
        TreeMap attrs = _Maps.newTreeMap();
        _Strings.splitThenStream((String)line.substring(p, q), (String)" ").map(attrLiteral -> _Strings.parseKeyValuePair((String)attrLiteral, (char)'=').orElseGet(() -> _Strings.pair((String)attrLiteral, null))).forEach(attr -> attrs.put((String)attr.getKey(), attr));
        attrs.values().forEach(attr -> chunks.add(attr.getValue() != null ? " " + (String)attr.getKey() + "=" + (String)attr.getValue() : " " + (String)attr.getKey()));
        chunks.add(">");
        return chunks.stream().collect(Collectors.joining());
    }

    public static Options gqlOptions() {
        return new Options().withScrubber(new Scrubber(){

            public String scrub(String s) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectMapper.readTree(s));
            }
        }).forFile().withExtension(".gql");
    }

    private ApprovalsOptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

