/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jpa.applib.types;

import java.util.Objects;
import java.util.Optional;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Lob;
import org.apache.causeway.applib.value.Clob;

@Embeddable
public final class ClobJpaEmbeddable {
    @Column(nullable=false, length=255)
    @Basic
    private String mimeType;
    @Column(nullable=false)
    @Lob
    @Basic
    private String chars;
    @Column(nullable=false, length=255)
    @Basic
    private String name;

    public static ClobJpaEmbeddable fromClob(Clob clob) {
        if (clob == null) {
            return null;
        }
        ClobJpaEmbeddable clobJpaEmbeddable = new ClobJpaEmbeddable();
        clobJpaEmbeddable.chars = clob.getChars().toString();
        clobJpaEmbeddable.mimeType = clob.getMimeType().toString();
        clobJpaEmbeddable.name = clob.getName();
        return clobJpaEmbeddable;
    }

    public static Clob toClob(ClobJpaEmbeddable clobJpaEmbeddable) {
        return Optional.ofNullable(clobJpaEmbeddable).map(ClobJpaEmbeddable::asClob).orElse(null);
    }

    public Clob asClob() {
        return new Clob(this.name, this.mimeType, (CharSequence)this.chars);
    }

    public String toString() {
        return this.asClob().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClobJpaEmbeddable that = (ClobJpaEmbeddable)o;
        if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
            return false;
        }
        if (!Objects.equals(this.chars, that.chars)) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.mimeType != null ? this.mimeType.hashCode() : 0;
        result = 31 * result + Objects.hashCode(this.chars);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getChars() {
        return this.chars;
    }

    public String getName() {
        return this.name;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setChars(String chars) {
        this.chars = chars;
    }

    public void setName(String name) {
        this.name = name;
    }
}

