/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jpa.applib.types;

import java.util.Arrays;
import java.util.Optional;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Lob;
import org.apache.causeway.applib.value.Blob;

@Embeddable
public final class BlobJpaEmbeddable {
    @Column(nullable=false, length=255)
    @Basic
    private String mimeType;
    @Column(nullable=false)
    @Lob
    @Basic
    private byte[] bytes;
    @Column(nullable=false, length=255)
    @Basic
    private String name;

    public static BlobJpaEmbeddable fromBlob(Blob blob) {
        if (blob == null) {
            return null;
        }
        BlobJpaEmbeddable blobJpaEmbeddable = new BlobJpaEmbeddable();
        blobJpaEmbeddable.bytes = blob.getBytes();
        blobJpaEmbeddable.mimeType = blob.getMimeType().toString();
        blobJpaEmbeddable.name = blob.getName();
        return blobJpaEmbeddable;
    }

    public static Blob toBlob(BlobJpaEmbeddable blobJpaEmbeddable) {
        return Optional.ofNullable(blobJpaEmbeddable).map(BlobJpaEmbeddable::asBlob).orElse(null);
    }

    public Blob asBlob() {
        return new Blob(this.name, this.mimeType, this.bytes);
    }

    public String toString() {
        return this.asBlob().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobJpaEmbeddable that = (BlobJpaEmbeddable)o;
        if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) {
            return false;
        }
        if (!Arrays.equals(this.bytes, that.bytes)) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.mimeType != null ? this.mimeType.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.name;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setName(String name) {
        this.name = name;
    }
}

