/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jpa.applib.services;

import javax.persistence.EntityManager;
import lombok.NonNull;
import org.apache.causeway.commons.functional.Try;

public interface JpaSupportService {
    public Try<EntityManager> getEntityManager(@NonNull Class<?> var1);

    default public EntityManager getEntityManagerElseFail(@NonNull Class<?> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return (EntityManager)this.getEntityManager(entityType).mapFailure(cause -> JpaSupportService.failureFor(entityType, cause)).getValue().orElseThrow(() -> JpaSupportService.failureFor(entityType));
    }

    private static IllegalStateException failureFor(@NonNull Class<?> entityType, Throwable cause) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return new IllegalStateException(JpaSupportService.failureMessage(entityType), cause);
    }

    private static IllegalStateException failureFor(@NonNull Class<?> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return new IllegalStateException(JpaSupportService.failureMessage(entityType));
    }

    private static String failureMessage(@NonNull Class<?> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return String.format("Current thread either has no open interaction or no unique EntityManager managing type %s can be resolved.", entityType);
    }
}

