/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.persistence.jpa.applib.integration;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.causeway.applib.services.repository.EntityState;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.functional.Either;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.object.MmEntityUtils;
import org.apache.causeway.core.metamodel.objectmanager.ObjectManager;
import org.apache.causeway.core.metamodel.services.objectlifecycle.ObjectLifecyclePublisher;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecord;
import org.apache.causeway.core.metamodel.services.objectlifecycle.PropertyChangeRecordId;
import org.apache.causeway.persistence.jpa.applib.services.JpaSupportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.changesets.DirectToFieldChangeRecord;
import org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet;
import org.springframework.lang.Nullable;

public class CausewayEntityListener {
    private static final Logger log = LogManager.getLogger(CausewayEntityListener.class);
    @Inject
    private ObjectLifecyclePublisher objectLifecyclePublisher;
    @Inject
    private Provider<JpaSupportService> jpaSupportServiceProvider;
    @Inject
    private ObjectManager objectManager;

    @PrePersist
    void onPrePersist(Object entityPojo) {
        log.debug("onPrePersist: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        this.objectLifecyclePublisher.onPrePersist(Either.left((Object)entity));
    }

    @PostLoad
    void onPostLoad(Object entityPojo) {
        log.debug("onPostLoad: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        EntityState entityState = entity.getEntityState();
        if (!entityState.isAttached()) {
            log.error("onPostLoad event while pojo not attached ({}); ignoring the event", (Object)entityState.name());
            return;
        }
        this.objectLifecyclePublisher.onPostLoad(entity);
    }

    @PreUpdate
    void onPreUpdate(Object entityPojo) {
        log.debug("onPreUpdate: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        this.objectLifecyclePublisher.onPreUpdate(entity, this::gatherPropertyChangeRecords);
    }

    @PreRemove
    void onPreRemove(Object entityPojo) {
        log.debug("onAnyRemove: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        this.objectLifecyclePublisher.onPreRemove(entity);
    }

    @PostPersist
    void onPostPersist(Object entityPojo) {
        log.debug("onPostPersist: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        this.objectLifecyclePublisher.onPostPersist(entity);
    }

    @PostUpdate
    void onPostUpdate(Object entityPojo) {
        log.debug("onPostUpdate: {}", entityPojo);
        ManagedObject entity = this.objectManager.adapt(entityPojo);
        this.objectLifecyclePublisher.onPostUpdate(entity);
    }

    @PostRemove
    void onPostRemove(Object entityPojo) {
        log.debug("onPostRemove: {}", entityPojo);
    }

    private Can<PropertyChangeRecord> gatherPropertyChangeRecords(@Nullable ManagedObject entity) {
        if (!ManagedObjects.isEntity((ManagedObject)entity)) {
            return Can.empty();
        }
        Object entityPojo = entity.getPojo();
        Optional entityManagerIfAny = ((JpaSupportService)this.jpaSupportServiceProvider.get()).getEntityManager(entityPojo.getClass()).getValue();
        Can propertyChangeRecords = entityManagerIfAny.map(em -> {
            UnitOfWork unwrap = (UnitOfWork)em.unwrap(UnitOfWork.class);
            UnitOfWorkChangeSet changes = unwrap.getCurrentChanges();
            return changes.getObjectChangeSetForClone(entityPojo);
        }).map(objectChanges -> (Can)objectChanges.getChanges().stream().filter(DirectToFieldChangeRecord.class::isInstance).map(DirectToFieldChangeRecord.class::cast).map(ormChangeRecord -> {
            String propertyName = ormChangeRecord.getAttribute();
            return MmEntityUtils.lookupPropertyChangeRecordIdForChangePublishing((ManagedObject)entity, (String)propertyName).map(id -> PropertyChangeRecord.ofCurrent((PropertyChangeRecordId)id, (Object)ormChangeRecord.getOldValue())).orElse(null);
        }).collect(Can.toCan())).orElseGet(Can::empty);
        return propertyChangeRecords;
    }
}

