/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.encryption.jbcrypt.services;

import jakarta.annotation.Priority;
import jakarta.inject.Named;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.secman.PasswordEncoderUsingJBcrypt")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Secman")
public class PasswordEncoderUsingJBcrypt
implements PasswordEncoder {
    private String salt;

    private String getSalt() {
        if (this.salt == null) {
            this.salt = BCrypt.gensalt();
        }
        return this.salt;
    }

    public String encode(CharSequence rawPassword) {
        return rawPassword == null ? null : BCrypt.hashpw((String)rawPassword.toString(), (String)this.getSalt());
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (rawPassword == null && encodedPassword == null) {
            return true;
        }
        if (rawPassword == null || encodedPassword == null) {
            return false;
        }
        return BCrypt.checkpw((String)rawPassword.toString(), (String)encodedPassword);
    }
}

