/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.util;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.causeway.commons.io.YamlUtils;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

public class ApplicationSecurityDto {
    private List<RoleDto> roles = new ArrayList<RoleDto>();
    private List<UserDto> users = new ArrayList<UserDto>();

    public static ApplicationSecurityDto create(@NonNull ApplicationRoleRepository applicationRoleRepository, @NonNull ApplicationUserRepository applicationUserRepository) {
        if (applicationRoleRepository == null) {
            throw new NullPointerException("applicationRoleRepository is marked non-null but is null");
        }
        if (applicationUserRepository == null) {
            throw new NullPointerException("applicationUserRepository is marked non-null but is null");
        }
        ApplicationSecurityDto model = new ApplicationSecurityDto();
        applicationRoleRepository.allRoles().stream().map(RoleDto::from).forEach(model.getRoles()::add);
        applicationUserRepository.allUsers().stream().map(UserDto::from).forEach(model.getUsers()::add);
        return model;
    }

    public String toYaml() {
        return YamlUtils.toStringUtf8((Object)this, (YamlUtils.YamlCustomizer[])new YamlUtils.YamlCustomizer[0]);
    }

    public List<RoleDto> getRoles() {
        return this.roles;
    }

    public List<UserDto> getUsers() {
        return this.users;
    }

    public void setRoles(List<RoleDto> roles) {
        this.roles = roles;
    }

    public void setUsers(List<UserDto> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationSecurityDto)) {
            return false;
        }
        ApplicationSecurityDto other = (ApplicationSecurityDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RoleDto> this$roles = this.getRoles();
        List<RoleDto> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<UserDto> this$users = this.getUsers();
        List<UserDto> other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationSecurityDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RoleDto> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<UserDto> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationSecurityDto(roles=" + this.getRoles() + ", users=" + this.getUsers() + ")";
    }

    public static class UserDto {
        String __username;
        List<String> roleNames = new ArrayList<String>();

        static UserDto from(ApplicationUser user) {
            UserDto userDto = new UserDto();
            userDto.set__username(user.getUsername());
            user.getRoles().stream().map(ApplicationRole::getName).forEach(userDto.getRoleNames()::add);
            return userDto;
        }

        public String get__username() {
            return this.__username;
        }

        public List<String> getRoleNames() {
            return this.roleNames;
        }

        public void set__username(String __username) {
            this.__username = __username;
        }

        public void setRoleNames(List<String> roleNames) {
            this.roleNames = roleNames;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDto)) {
                return false;
            }
            UserDto other = (UserDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$__username = this.get__username();
            String other$__username = other.get__username();
            if (this$__username == null ? other$__username != null : !this$__username.equals(other$__username)) {
                return false;
            }
            List<String> this$roleNames = this.getRoleNames();
            List<String> other$roleNames = other.getRoleNames();
            return !(this$roleNames == null ? other$roleNames != null : !((Object)this$roleNames).equals(other$roleNames));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $__username = this.get__username();
            result = result * 59 + ($__username == null ? 43 : $__username.hashCode());
            List<String> $roleNames = this.getRoleNames();
            result = result * 59 + ($roleNames == null ? 43 : ((Object)$roleNames).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationSecurityDto.UserDto(__username=" + this.get__username() + ", roleNames=" + this.getRoleNames() + ")";
        }
    }

    public static class RoleDto {
        String __name;
        String description;
        List<PermissionDto> permissions = new ArrayList<PermissionDto>();

        static RoleDto from(ApplicationRole role) {
            RoleDto roleDto = new RoleDto();
            roleDto.set__name(role.getName());
            roleDto.setDescription(role.getDescription());
            role.getPermissions().stream().map(PermissionDto::from).forEach(roleDto.getPermissions()::add);
            return roleDto;
        }

        public String get__name() {
            return this.__name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<PermissionDto> getPermissions() {
            return this.permissions;
        }

        public void set__name(String __name) {
            this.__name = __name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setPermissions(List<PermissionDto> permissions) {
            this.permissions = permissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleDto)) {
                return false;
            }
            RoleDto other = (RoleDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$__name = this.get__name();
            String other$__name = other.get__name();
            if (this$__name == null ? other$__name != null : !this$__name.equals(other$__name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<PermissionDto> this$permissions = this.getPermissions();
            List<PermissionDto> other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoleDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $__name = this.get__name();
            result = result * 59 + ($__name == null ? 43 : $__name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<PermissionDto> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationSecurityDto.RoleDto(__name=" + this.get__name() + ", description=" + this.getDescription() + ", permissions=" + this.getPermissions() + ")";
        }
    }

    public static class PermissionDto {
        String featureFqn;
        ApplicationFeatureSort featureSort;
        ApplicationPermissionMode mode;
        ApplicationPermissionRule rule;

        static PermissionDto from(ApplicationPermission permission) {
            PermissionDto permissionDto = new PermissionDto();
            permissionDto.setFeatureFqn(permission.getFeatureFqn());
            permissionDto.setFeatureSort(permission.getFeatureSort());
            permissionDto.setMode(permission.getMode());
            permissionDto.setRule(permission.getRule());
            return permissionDto;
        }

        public String getFeatureFqn() {
            return this.featureFqn;
        }

        public ApplicationFeatureSort getFeatureSort() {
            return this.featureSort;
        }

        public ApplicationPermissionMode getMode() {
            return this.mode;
        }

        public ApplicationPermissionRule getRule() {
            return this.rule;
        }

        public void setFeatureFqn(String featureFqn) {
            this.featureFqn = featureFqn;
        }

        public void setFeatureSort(ApplicationFeatureSort featureSort) {
            this.featureSort = featureSort;
        }

        public void setMode(ApplicationPermissionMode mode) {
            this.mode = mode;
        }

        public void setRule(ApplicationPermissionRule rule) {
            this.rule = rule;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionDto)) {
                return false;
            }
            PermissionDto other = (PermissionDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$featureFqn = this.getFeatureFqn();
            String other$featureFqn = other.getFeatureFqn();
            if (this$featureFqn == null ? other$featureFqn != null : !this$featureFqn.equals(other$featureFqn)) {
                return false;
            }
            ApplicationFeatureSort this$featureSort = this.getFeatureSort();
            ApplicationFeatureSort other$featureSort = other.getFeatureSort();
            if (this$featureSort == null ? other$featureSort != null : !this$featureSort.equals(other$featureSort)) {
                return false;
            }
            ApplicationPermissionMode this$mode = this.getMode();
            ApplicationPermissionMode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
                return false;
            }
            ApplicationPermissionRule this$rule = this.getRule();
            ApplicationPermissionRule other$rule = other.getRule();
            return !(this$rule == null ? other$rule != null : !((Object)((Object)this$rule)).equals((Object)other$rule));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PermissionDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $featureFqn = this.getFeatureFqn();
            result = result * 59 + ($featureFqn == null ? 43 : $featureFqn.hashCode());
            ApplicationFeatureSort $featureSort = this.getFeatureSort();
            result = result * 59 + ($featureSort == null ? 43 : $featureSort.hashCode());
            ApplicationPermissionMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
            ApplicationPermissionRule $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : ((Object)((Object)$rule)).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationSecurityDto.PermissionDto(featureFqn=" + this.getFeatureFqn() + ", featureSort=" + this.getFeatureSort() + ", mode=" + this.getMode() + ", rule=" + this.getRule() + ")";
        }
    }
}

