/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.menu;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.Domain;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.NatureOfService;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.queryresultscache.QueryResultsCache;
import org.apache.causeway.applib.services.user.UserService;
import org.apache.causeway.applib.services.userui.UserMenu;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Named(value="causeway.ext.secman.MeService")
@DomainService(nature=NatureOfService.VIEW)
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.TERTIARY)
@Priority(value=0x1FFFFFFF)
public class MeService {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.MeService";
    final ApplicationUserRepository applicationUserRepository;
    final UserService userService;
    final Provider<QueryResultsCache> queryResultsCacheProvider;

    @ObjectSupport
    public String iconName() {
        return "applicationUser";
    }

    @Inject
    public MeService(ApplicationUserRepository applicationUserRepository, UserService userService, Provider<QueryResultsCache> queryResultsCacheProvider) {
        this.applicationUserRepository = applicationUserRepository;
        this.userService = userService;
        this.queryResultsCacheProvider = queryResultsCacheProvider;
    }

    @Component
    public static class UserMenuMeActionAdvisor {
        final CausewayConfiguration causewayConfiguration;

        @EventListener(value={UserMenu.me.ActionDomainEvent.class})
        public void on(UserMenu.me.ActionDomainEvent event) {
            switch (this.causewayConfiguration.getExtensions().getSecman().getUserMenuMeActionPolicy()) {
                case HIDE: {
                    event.hide();
                    break;
                }
                case DISABLE: {
                    event.disable("Use security manager's action to view the current user");
                    break;
                }
            }
        }

        public UserMenuMeActionAdvisor(CausewayConfiguration causewayConfiguration) {
            this.causewayConfiguration = causewayConfiguration;
        }
    }

    @Action(domainEvent=ActionDomainEvent.class, semantics=SemanticsOf.SAFE)
    @ActionLayout(cssClassFa="fa-user", describedAs="Looks up ApplicationUser entity corresponding to your user account", sequence="100")
    public class me {
        @MemberSupport
        public ApplicationUser act() {
            return (ApplicationUser)((QueryResultsCache)MeService.this.queryResultsCacheProvider.get()).execute(this::fetchMe, MeService.class, "me", new Object[0]);
        }

        @Domain.Exclude
        protected ApplicationUser fetchMe() {
            String myName = MeService.this.userService.currentUserNameElseNobody();
            return this.fetchMe(myName);
        }

        @Domain.Exclude
        protected ApplicationUser fetchMe(String myName) {
            return MeService.this.applicationUserRepository.findOrCreateUserByUsername(myName);
        }

        public class ActionDomainEvent
        extends org.apache.causeway.extensions.secman.applib.user.menu.MeService$ActionDomainEvent<me> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<T> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.CollectionDomainEvent<MeService, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<MeService, T> {
    }
}

