/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.man.mixins;

import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.apache.causeway.extensions.secman.applib.user.man.ApplicationUserManager;

@Action(domainEvent=DomainEvent.class)
@ActionLayout(associateWith="allUsers", sequence="2")
public class ApplicationUserManager_newDelegateUser {
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private CausewayConfiguration config;
    @Inject
    private RepositoryService repository;
    private final ApplicationUserManager target;

    @MemberSupport
    public ApplicationUserManager act(@Parameter(maxLength=120) @ParameterLayout(named="Name") String username, @Parameter(optionality=Optionality.OPTIONAL) @ParameterLayout(named="Initial role") ApplicationRole initialRole, @Parameter(optionality=Optionality.OPTIONAL) @ParameterLayout(named="Unlocked?") Boolean unlocked) {
        ApplicationUser user = this.applicationUserRepository.newDelegateUser(username, ApplicationUserStatus.parse(unlocked));
        if (initialRole != null) {
            this.applicationRoleRepository.addRoleToUser(initialRole, user);
        }
        this.repository.persist((Object)user);
        return this.target;
    }

    @MemberSupport
    public ApplicationRole defaultInitialRole() {
        String regularUserRoleName = this.config.getExtensions().getSecman().getSeed().getRegularUser().getRoleName();
        return this.applicationRoleRepository.findByNameCached(regularUserRoleName).orElse(null);
    }

    public ApplicationUserManager_newDelegateUser(ApplicationUserManager target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUserManager_newDelegateUser> {
    }
}

