/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.fixtures;

import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.causeway.applib.services.inject.ServiceInjector;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.AccountType;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;
import org.apache.causeway.testing.fixtures.applib.fixturescripts.FixtureScript;

public abstract class AbstractUserAndRolesFixtureScript
extends FixtureScript {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ServiceInjector serviceInjector;
    private final Supplier<String> usernameSupplier;
    private final Supplier<String> passwordSupplier;
    private final Supplier<String> emailAddressSupplier;
    private final Supplier<String> tenancyPathSupplier;
    private final Supplier<AccountType> accountTypeSupplier;
    private final Supplier<Can<String>> roleNamesSupplier;
    private ApplicationUser applicationUser;

    public AbstractUserAndRolesFixtureScript(String username, String password, AccountType accountType, Can<String> roleNames) {
        this(username, password, null, null, accountType, roleNames);
    }

    public AbstractUserAndRolesFixtureScript(Supplier<String> usernameSupplier, Supplier<String> passwordSupplier, Supplier<AccountType> accountTypeSupplier, Supplier<Can<String>> roleNamesSupplier) {
        this(usernameSupplier, passwordSupplier, () -> null, () -> null, accountTypeSupplier, roleNamesSupplier);
    }

    public AbstractUserAndRolesFixtureScript(String username, String password, String emailAddress, String tenancyPath, AccountType accountType, Can<String> roleNames) {
        this(() -> username, () -> password, () -> emailAddress, () -> tenancyPath, () -> accountType, () -> roleNames);
    }

    public AbstractUserAndRolesFixtureScript(Supplier<String> usernameSupplier, Supplier<String> passwordSupplier, Supplier<String> emailAddressSupplier, Supplier<String> tenancyPathSupplier, Supplier<AccountType> accountTypeSupplier, Supplier<Can<String>> roleNamesSupplier) {
        this.usernameSupplier = AbstractUserAndRolesFixtureScript.nullSafe(usernameSupplier);
        this.passwordSupplier = AbstractUserAndRolesFixtureScript.nullSafe(passwordSupplier);
        this.emailAddressSupplier = AbstractUserAndRolesFixtureScript.nullSafe(emailAddressSupplier);
        this.tenancyPathSupplier = AbstractUserAndRolesFixtureScript.nullSafe(tenancyPathSupplier);
        this.accountTypeSupplier = AbstractUserAndRolesFixtureScript.nullSafe(accountTypeSupplier);
        this.roleNamesSupplier = AbstractUserAndRolesFixtureScript.nullSafe(roleNamesSupplier);
    }

    protected final String getUsername() {
        return this.usernameSupplier.get();
    }

    protected String getPassword() {
        return this.passwordSupplier.get();
    }

    protected final String getEmailAddress() {
        return this.emailAddressSupplier.get();
    }

    protected final String getTenancyPath() {
        return this.tenancyPathSupplier.get();
    }

    protected final AccountType getAccountType() {
        return this.accountTypeSupplier.get();
    }

    protected final Can<String> getRoleNames() {
        return this.roleNamesSupplier.get();
    }

    protected void execute(FixtureScript.ExecutionContext executionContext) {
        this.serviceInjector.injectServicesInto(this.usernameSupplier);
        this.serviceInjector.injectServicesInto(this.passwordSupplier);
        this.serviceInjector.injectServicesInto(this.emailAddressSupplier);
        this.serviceInjector.injectServicesInto(this.tenancyPathSupplier);
        this.serviceInjector.injectServicesInto(this.accountTypeSupplier);
        this.serviceInjector.injectServicesInto(this.roleNamesSupplier);
        String username = this.getUsername();
        this.applicationUser = this.applicationUserRepository.findByUsername(username).orElse(null);
        if (this.applicationUser == null) {
            switch (this.getAccountType()) {
                case DELEGATED: {
                    this.applicationUser = this.applicationUserRepository.newDelegateUser(username, ApplicationUserStatus.UNLOCKED);
                    break;
                }
                case LOCAL: {
                    Password pwd = new Password(this.getPassword());
                    this.applicationUser = this.applicationUserRepository.newLocalUser(username, pwd, ApplicationUserStatus.UNLOCKED);
                    this.applicationUser.setEmailAddress(this.getEmailAddress());
                }
            }
            if (this.applicationUser == null) {
                throw _Exceptions.unrecoverable((String)"failed to create user '%s'", (Object[])new Object[]{username});
            }
            this.applicationUser.setAtPath(this.getTenancyPath());
        }
        for (String roleName : this.getRoleNames()) {
            this.applicationRoleRepository.findByName(roleName).map(securityRole -> {
                this.applicationRoleRepository.addRoleToUser((ApplicationRole)securityRole, this.applicationUser);
                return Boolean.TRUE;
            }).orElseThrow(() -> _Exceptions.unrecoverable((String)("role not found by name: " + roleName)));
        }
    }

    private static <T> Supplier<T> nullSafe(Supplier<T> supplier) {
        return supplier != null ? supplier : () -> null;
    }

    public ApplicationUser getApplicationUser() {
        return this.applicationUser;
    }
}

