/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.events;

import lombok.NonNull;
import org.apache.causeway.extensions.secman.applib.user.dom.AccountType;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;

public final class UserCreatedEvent {
    @NonNull
    private final ApplicationUser user;

    public AccountType getAccountType() {
        return this.user.getAccountType();
    }

    public String getUserName() {
        return this.user.getUsername();
    }

    public boolean isDelegated() {
        return this.getAccountType() != null && this.getAccountType().isDelegated();
    }

    private UserCreatedEvent(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
    }

    public static UserCreatedEvent of(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return new UserCreatedEvent(user);
    }

    @NonNull
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserCreatedEvent)) {
            return false;
        }
        UserCreatedEvent other = (UserCreatedEvent)o;
        ApplicationUser this$user = this.getUser();
        ApplicationUser other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "UserCreatedEvent(user=" + this.getUser() + ")";
    }
}

