/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins.perms;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.ViewModel;
import org.apache.causeway.applib.annotation.BookmarkPolicy;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.Nature;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureSort;
import org.apache.causeway.applib.services.appfeatui.ApplicationFeatureViewModel;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.commons.internal.base._Bytes;
import org.apache.causeway.commons.internal.resources._Serializables;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermission;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionMode;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRepository;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionRule;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValue;
import org.apache.causeway.extensions.secman.applib.permission.dom.ApplicationPermissionValueSet;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Named(value="causeway.ext.secman.UserPermissionViewModel")
@DomainObject(nature=Nature.VIEW_MODEL)
@DomainObjectLayout(bookmarking=BookmarkPolicy.AS_ROOT)
public class UserPermissionViewModel
implements ViewModel {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.secman.UserPermissionViewModel";
    @Inject
    ApplicationUserRepository applicationUserRepository;
    @Inject
    FactoryService factory;
    @Inject
    ApplicationFeatureRepository featureRepository;
    @Inject
    ApplicationPermissionRepository applicationPermissionRepository;
    private String username;
    private boolean viewingGranted;
    private boolean changingGranted;
    private ApplicationFeatureId featureId;
    private ApplicationFeatureId viewingFeatureId;
    private ApplicationPermissionMode viewingMode;
    private ApplicationPermissionRule viewingRule;
    private ApplicationFeatureId changingFeatureId;
    private ApplicationPermissionMode changingMode;
    private ApplicationPermissionRule changingRule;
    private static final ToString<UserPermissionViewModel> toString = ObjectContracts.toString((String)"user", UserPermissionViewModel::getUser).thenToString("featureId", UserPermissionViewModel::getFeatureId);

    public static String memento(ApplicationFeatureId featureId, ApplicationUser user, ApplicationPermissionValueSet.Evaluation viewingEvaluation, ApplicationPermissionValueSet.Evaluation changingEvaluation) {
        return UserPermissionViewModel.asEncodedString(featureId, user.getUsername(), viewingEvaluation, changingEvaluation);
    }

    public UserPermissionViewModel() {
        this.setFeatureId(ApplicationFeatureId.NAMESPACE_DEFAULT);
    }

    @ObjectSupport
    public String title() {
        return this.getVerb() + " " + this.getFeatureId().getFullyQualifiedName();
    }

    @ObjectSupport
    public String iconName() {
        return "userPermission";
    }

    @Inject
    public UserPermissionViewModel(String memento) {
        String[] payload = (String[])_Serializables.read(String[].class, (byte[])_Bytes.ofUrlBase64.apply(memento.getBytes(StandardCharsets.US_ASCII)));
        this.parse(payload);
    }

    public String viewModelMemento() {
        return UserPermissionViewModel.asEncodedString(this.getFeatureId(), this.getUsername(), UserPermissionViewModel.newEvaluation(this.viewingGranted, this.viewingFeatureId, this.viewingRule, this.viewingMode), UserPermissionViewModel.newEvaluation(this.changingGranted, this.changingFeatureId, this.changingRule, this.changingMode));
    }

    private static String asEncodedString(ApplicationFeatureId featureId, String username, ApplicationPermissionValueSet.Evaluation viewingEvaluation, ApplicationPermissionValueSet.Evaluation changingEvaluation) {
        ApplicationPermissionValue viewingEvaluationCause = viewingEvaluation.getCause();
        ApplicationFeatureId viewingEvaluationCauseFeatureId = viewingEvaluationCause != null ? viewingEvaluationCause.getFeatureId() : null;
        ApplicationPermissionValue changingEvaluationCause = changingEvaluation.getCause();
        ApplicationFeatureId changingEvaluationCauseFeatureId = changingEvaluationCause != null ? changingEvaluationCause.getFeatureId() : null;
        String[] payload = new String[]{username, "" + viewingEvaluation.isGranted(), viewingEvaluationCauseFeatureId != null ? "" + viewingEvaluationCauseFeatureId.getSort() : "", viewingEvaluationCauseFeatureId != null ? viewingEvaluationCauseFeatureId.getFullyQualifiedName() : "", viewingEvaluationCause != null ? "" + viewingEvaluationCause.getRule() : "", viewingEvaluationCause != null ? "" + viewingEvaluationCause.getMode() : "", "" + changingEvaluation.isGranted(), changingEvaluationCauseFeatureId != null ? "" + changingEvaluationCauseFeatureId.getSort() : "", changingEvaluationCauseFeatureId != null ? changingEvaluationCauseFeatureId.getFullyQualifiedName() : "", changingEvaluationCause != null ? "" + changingEvaluationCause.getRule() : "", changingEvaluationCause != null ? "" + changingEvaluationCause.getMode() : "", "" + featureId.getSort(), featureId.getFullyQualifiedName()};
        return new String(_Bytes.asUrlBase64.apply(_Serializables.write((Serializable)payload)), StandardCharsets.US_ASCII);
    }

    private void parse(String[] payload) {
        Iterator<String> iterator = Arrays.asList(payload).iterator();
        this.username = iterator.next();
        this.viewingGranted = Boolean.parseBoolean(iterator.next());
        String viewingEvaluationCauseFeatureIdType = iterator.next();
        ApplicationFeatureSort viewingEvaluationFeatureIdType = !viewingEvaluationCauseFeatureIdType.isEmpty() ? ApplicationFeatureSort.valueOf((String)viewingEvaluationCauseFeatureIdType) : null;
        String viewingEvaluationFeatureFqn = iterator.next();
        this.viewingFeatureId = viewingEvaluationFeatureIdType != null ? ApplicationFeatureId.newFeature((ApplicationFeatureSort)viewingEvaluationFeatureIdType, (String)viewingEvaluationFeatureFqn) : null;
        String viewingEvaluationCauseRule = iterator.next();
        this.viewingRule = !viewingEvaluationCauseRule.isEmpty() ? ApplicationPermissionRule.valueOf(viewingEvaluationCauseRule) : null;
        String viewingEvaluationCauseMode = iterator.next();
        this.viewingMode = !viewingEvaluationCauseMode.isEmpty() ? ApplicationPermissionMode.valueOf(viewingEvaluationCauseMode) : null;
        this.changingGranted = Boolean.parseBoolean(iterator.next());
        String changingEvaluationCauseFeatureIdType = iterator.next();
        ApplicationFeatureSort changingEvaluationFeatureIdType = !changingEvaluationCauseFeatureIdType.isEmpty() ? ApplicationFeatureSort.valueOf((String)changingEvaluationCauseFeatureIdType) : null;
        String changingEvaluationFeatureFqn = iterator.next();
        this.changingFeatureId = changingEvaluationFeatureIdType != null ? ApplicationFeatureId.newFeature((ApplicationFeatureSort)changingEvaluationFeatureIdType, (String)changingEvaluationFeatureFqn) : null;
        String changingEvaluationCauseRule = iterator.next();
        this.changingRule = !changingEvaluationCauseRule.isEmpty() ? ApplicationPermissionRule.valueOf(changingEvaluationCauseRule) : null;
        String changingEvaluationCauseMode = iterator.next();
        this.changingMode = !changingEvaluationCauseMode.isEmpty() ? ApplicationPermissionMode.valueOf(changingEvaluationCauseMode) : null;
        ApplicationFeatureSort type = ApplicationFeatureSort.valueOf((String)iterator.next());
        this.featureId = ApplicationFeatureId.newFeature((ApplicationFeatureSort)type, (String)iterator.next());
    }

    private static ApplicationPermissionValueSet.Evaluation newEvaluation(boolean granted, ApplicationFeatureId featureId, ApplicationPermissionRule rule, ApplicationPermissionMode mode) {
        return new ApplicationPermissionValueSet.Evaluation(UserPermissionViewModel.newPermissionValue(featureId, rule, mode), granted);
    }

    private static ApplicationPermissionValue newPermissionValue(ApplicationFeatureId featureId, ApplicationPermissionRule rule, ApplicationPermissionMode mode) {
        if (featureId == null || mode == null || rule == null) {
            return null;
        }
        return new ApplicationPermissionValue(featureId, rule, mode);
    }

    @User
    public ApplicationUser getUser() {
        return this.applicationUserRepository.findOrCreateUserByUsername(this.getUsername());
    }

    @Verb
    public String getVerb() {
        return this.changingGranted ? "Can change" : (this.viewingGranted ? "Can view" : "No access to");
    }

    @Feature
    public ApplicationFeatureViewModel getFeature() {
        if (this.getFeatureId() == null) {
            return null;
        }
        return ApplicationFeatureViewModel.newViewModel((ApplicationFeatureId)this.getFeatureId(), (ApplicationFeatureRepository)this.featureRepository, (FactoryService)this.factory);
    }

    @ViewingPermission
    public ApplicationPermission getViewingPermission() {
        return this.getViewingPermissionValue() == null ? null : (ApplicationPermission)this.applicationPermissionRepository.findByUserAndPermissionValue(this.username, this.getViewingPermissionValue()).orElse(null);
    }

    private ApplicationPermissionValue getViewingPermissionValue() {
        return this.viewingFeatureId == null ? null : new ApplicationPermissionValue(this.viewingFeatureId, this.viewingRule, this.viewingMode);
    }

    @ChangingPermission
    public ApplicationPermission getChangingPermission() {
        return this.getChangingPermissionValue() == null ? null : (ApplicationPermission)this.applicationPermissionRepository.findByUserAndPermissionValue(this.username, this.getChangingPermissionValue()).orElse(null);
    }

    private ApplicationPermissionValue getChangingPermissionValue() {
        return this.changingFeatureId == null ? null : new ApplicationPermissionValue(this.changingFeatureId, this.changingRule, this.changingMode);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    public static Function<ApplicationFeatureId, UserPermissionViewModel> asViewModel(ApplicationUser user, FactoryService factoryService) {
        return featureId -> {
            ApplicationPermissionValueSet permissionSet = user.getPermissionSet();
            ApplicationPermissionValueSet.Evaluation changingEvaluation = permissionSet.evaluate((ApplicationFeatureId)featureId, ApplicationPermissionMode.CHANGING);
            ApplicationPermissionValueSet.Evaluation viewingEvaluation = permissionSet.evaluate((ApplicationFeatureId)featureId, ApplicationPermissionMode.VIEWING);
            return (UserPermissionViewModel)factoryService.viewModel((Object)new UserPermissionViewModel(UserPermissionViewModel.memento(featureId, user, viewingEvaluation, changingEvaluation)));
        };
    }

    @Programmatic
    public String getUsername() {
        return this.username;
    }

    @Programmatic
    public ApplicationFeatureId getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(ApplicationFeatureId featureId) {
        this.featureId = featureId;
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="cause", hidden=Where.REFERENCES_PARENT, sequence="2")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ChangingPermission {

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationPermission> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="cause", hidden=Where.REFERENCES_PARENT, sequence="1")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ViewingPermission {

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationPermission> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(fieldSetId="identity", hidden=Where.REFERENCES_PARENT, sequence="4")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Feature {

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationFeatureViewModel> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="identity", sequence="2", typicalLength=12)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Verb {
        public static final int TYPICAL_LENGTH = 12;

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(fieldSetId="identity", hidden=Where.PARENTED_TABLES, sequence="1")
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface User {

        public static class DomainEvent
        extends PropertyDomainEvent<ApplicationUser> {
        }
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtSecmanApplib.PropertyDomainEvent<UserPermissionViewModel, T> {
    }
}

