/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins.perms;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.MinLength;
import org.apache.causeway.applib.annotation.ParameterLayout;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.appfeat.ApplicationFeature;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.feature.api.ApplicationFeatureChoices;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.mixins.perms.UserPermissionViewModel;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.SAFE)
@ActionLayout(associateWith="effectiveMemberPermissions", named="Filter", promptStyle=PromptStyle.DIALOG_MODAL, sequence="1")
public class ApplicationUser_filterEffectiveMemberPermissions {
    @Inject
    private FactoryService factory;
    @Inject
    private ApplicationFeatureRepository featureRepository;
    @Inject
    private ApplicationFeatureChoices applicationFeatureChoices;
    private final ApplicationUser user;

    @MemberSupport
    public List<UserPermissionViewModel> act(@ParameterLayout(describedAs="To refine the search by feature-sort (namespace, type, member), use one of n: t: m:") ApplicationFeatureChoices.AppFeat feature) {
        return this.featureRepository.allMembers().stream().map(ApplicationFeature::getFeatureId).filter(arg_0 -> ((ApplicationFeatureId)feature.getFeatureId()).contains(arg_0)).map(UserPermissionViewModel.asViewModel(this.user, this.factory)).collect(Collectors.toList());
    }

    @MemberSupport
    public Collection<ApplicationFeatureChoices.AppFeat> autoComplete0Act(@MinLength(value=3) String search) {
        return this.applicationFeatureChoices.autoCompleteFeature(search);
    }

    public ApplicationUser_filterEffectiveMemberPermissions(ApplicationUser user) {
        this.user = user;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_filterEffectiveMemberPermissions> {
    }
}

