/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import java.util.Objects;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.crypto.password.PasswordEncoder;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="hasPassword", sequence="10")
public class ApplicationUser_updatePassword {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Autowired(required=false)
    @Qualifier(value="Secman")
    private PasswordEncoder passwordEncoder;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act(Password existingPassword, Password newPassword, Password repeatNewPassword) {
        this.applicationUserRepository.updatePassword(this.target, newPassword.getPassword());
        return this.target;
    }

    @MemberSupport
    public boolean hideAct() {
        return !this.applicationUserRepository.isPasswordFeatureEnabled(this.target);
    }

    @MemberSupport
    public String disableAct() {
        if (!this.target.isForSelfOrRunAsAdministrator()) {
            return "Can only update password for your own user account.";
        }
        if (!this.target.isHasPassword()) {
            return "Password must be reset by administrator.";
        }
        return null;
    }

    @MemberSupport
    public String validateAct(Password existingPassword, Password newPassword, Password repeatNewPassword) {
        if (!this.applicationUserRepository.isPasswordFeatureEnabled(this.target)) {
            return "Password feature is not available for this User";
        }
        Objects.requireNonNull(this.passwordEncoder);
        String encryptedPassword = this.target.getEncryptedPassword();
        if (this.target.getEncryptedPassword() != null && !this.passwordEncoder.matches((CharSequence)existingPassword.getPassword(), encryptedPassword)) {
            return "Existing password is incorrect";
        }
        if (!Objects.equals(newPassword, repeatNewPassword)) {
            return "Passwords do not match";
        }
        return null;
    }

    public ApplicationUser_updatePassword(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_updatePassword> {
    }
}

