/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.locale.LocaleChoiceProvider;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="language", promptStyle=PromptStyle.INLINE_AS_IF_EDIT, sequence="1")
public class ApplicationUser_updateLocale {
    @Inject
    LocaleChoiceProvider localeChoiceProvider;
    private final ApplicationUser mixee;

    @MemberSupport
    public ApplicationUser act(@ApplicationUser.Locale Locale language, @ApplicationUser.Locale Locale numberFormat, @ApplicationUser.Locale Locale timeFormat) {
        this.mixee.setLanguage(language);
        this.mixee.setNumberFormat(numberFormat);
        this.mixee.setTimeFormat(timeFormat);
        return this.mixee;
    }

    @MemberSupport
    public String disableAct() {
        return this.mixee.isForSelfOrRunAsAdministrator() ? null : "Can only update your own user record.";
    }

    @MemberSupport
    public Locale defaultLanguage(Parameters p) {
        return this.mixee.getLanguage();
    }

    @MemberSupport
    public List<Locale> choicesLanguage(Parameters p) {
        return this.localeChoiceProvider.getAvailableLocales();
    }

    @MemberSupport
    public Locale defaultNumberFormat(Parameters p) {
        return this.mixee.getNumberFormat() != null ? this.mixee.getNumberFormat() : p.language();
    }

    @MemberSupport
    public List<Locale> choicesNumberFormat(Parameters p) {
        return this.localeChoiceProvider.getAvailableLocales();
    }

    @MemberSupport
    public Locale defaultTimeFormat(Parameters p) {
        return this.mixee.getTimeFormat() != null ? this.mixee.getTimeFormat() : p.language();
    }

    @MemberSupport
    public List<Locale> choicesTimeFormat(Parameters p) {
        return this.localeChoiceProvider.getAvailableLocales();
    }

    public ApplicationUser_updateLocale(ApplicationUser mixee) {
        this.mixee = mixee;
    }

    public static final class Parameters {
        private final Locale language;
        private final Locale numberFormat;
        private final Locale timeFormat;

        public Parameters(Locale language, Locale numberFormat, Locale timeFormat) {
            this.language = language;
            this.numberFormat = numberFormat;
            this.timeFormat = timeFormat;
        }

        public Locale language() {
            return this.language;
        }

        public Locale numberFormat() {
            return this.numberFormat;
        }

        public Locale timeFormat() {
            return this.timeFormat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)o;
            Locale this$language = this.language();
            Locale other$language = other.language();
            if (this$language == null ? other$language != null : !((Object)this$language).equals(other$language)) {
                return false;
            }
            Locale this$numberFormat = this.numberFormat();
            Locale other$numberFormat = other.numberFormat();
            if (this$numberFormat == null ? other$numberFormat != null : !((Object)this$numberFormat).equals(other$numberFormat)) {
                return false;
            }
            Locale this$timeFormat = this.timeFormat();
            Locale other$timeFormat = other.timeFormat();
            return !(this$timeFormat == null ? other$timeFormat != null : !((Object)this$timeFormat).equals(other$timeFormat));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Locale $language = this.language();
            result = result * 59 + ($language == null ? 43 : ((Object)$language).hashCode());
            Locale $numberFormat = this.numberFormat();
            result = result * 59 + ($numberFormat == null ? 43 : ((Object)$numberFormat).hashCode());
            Locale $timeFormat = this.timeFormat();
            result = result * 59 + ($timeFormat == null ? 43 : ((Object)$timeFormat).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationUser_updateLocale.Parameters(language=" + this.language() + ", numberFormat=" + this.numberFormat() + ", timeFormat=" + this.timeFormat() + ")";
        }
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_updateLocale> {
    }
}

