/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.PromptStyle;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.AccountType;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="accountType", promptStyle=PromptStyle.INLINE_AS_IF_EDIT, sequence="1")
public class ApplicationUser_updateAccountType {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act(AccountType accountType) {
        this.target.setAccountType(accountType);
        return this.target;
    }

    @MemberSupport
    public String disableAct() {
        return this.applicationUserRepository.isAdminUser(this.target) ? "Cannot change account type for admin user" : null;
    }

    @MemberSupport
    public AccountType default0Act() {
        return this.target.getAccountType();
    }

    public ApplicationUser_updateAccountType(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_updateAccountType> {
    }
}

