/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import java.util.Objects;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.value.Password;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="hasPassword", sequence="20")
public class ApplicationUser_resetPassword {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act(Password newPassword, Password repeatPassword) {
        this.applicationUserRepository.updatePassword(this.target, newPassword.getPassword());
        return this.target;
    }

    @MemberSupport
    public boolean hideAct() {
        return !this.applicationUserRepository.isPasswordFeatureEnabled(this.target);
    }

    @MemberSupport
    public String validateAct(Password newPassword, Password repeatPassword) {
        if (!this.applicationUserRepository.isPasswordFeatureEnabled(this.target)) {
            return "Password feature is not available for this User";
        }
        if (!Objects.equals(newPassword, repeatPassword)) {
            return "Passwords do not match";
        }
        return null;
    }

    public ApplicationUser_resetPassword(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_resetPassword> {
    }
}

