/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import java.util.Collection;
import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.message.MessageService;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRole;
import org.apache.causeway.extensions.secman.applib.role.dom.ApplicationRoleRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;

@Action(choicesFrom="roles", domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="roles", named="Remove", sequence="2")
public class ApplicationUser_removeRoles {
    @Inject
    private MessageService messageService;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act(Collection<ApplicationRole> roles) {
        _NullSafe.stream(roles).filter(this::canRemove).forEach(role -> this.applicationRoleRepository.removeRoleFromUser((ApplicationRole)role, this.target));
        return this.target;
    }

    @Programmatic
    public boolean canRemove(ApplicationRole applicationRole) {
        if (this.applicationUserRepository.isAdminUser(this.target) && this.applicationRoleRepository.isAdminRole(applicationRole)) {
            this.messageService.warnUser("Cannot remove admin user from the admin role.");
            return false;
        }
        return true;
    }

    public ApplicationUser_removeRoles(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_removeRoles> {
    }
}

