/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.secman.applib.user.dom.mixins;

import javax.inject.Inject;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.secman.applib.CausewayModuleExtSecmanApplib;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUser;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserRepository;
import org.apache.causeway.extensions.secman.applib.user.dom.ApplicationUserStatus;

@Action(domainEvent=DomainEvent.class, semantics=SemanticsOf.IDEMPOTENT)
@ActionLayout(associateWith="status", cssClassFa="fa-lock", sequence="2")
public class ApplicationUser_lock {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private CausewayConfiguration config;
    private final ApplicationUser target;

    @MemberSupport
    public ApplicationUser act() {
        this.target.setStatus(ApplicationUserStatus.LOCKED);
        return this.target;
    }

    @MemberSupport
    public String disableAct() {
        if (this.applicationUserRepository.isAdminUser(this.target)) {
            return String.format("Cannot lock the '%s' user.", this.config.getExtensions().getSecman().getSeed().getAdmin().getUserName());
        }
        return ApplicationUserStatus.canLock(this.target.getStatus()) ? null : "Status is already set to LOCKED";
    }

    public ApplicationUser_lock(ApplicationUser target) {
        this.target = target;
    }

    public static class DomainEvent
    extends CausewayModuleExtSecmanApplib.ActionDomainEvent<ApplicationUser_lock> {
    }
}

